/*
 * Decompiled with CFR 0.152.
 */
package commands.changemarkfield;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.TextStyleChangeable;
import document.text.TextStyle;
import document.text.TextStyleFactory;
import java.awt.Color;

public class SetFontColor
extends AbstractCommand {
    private Color oldfontColor;
    private Color newfontColor;
    private TextStyleChangeable textStyleChangeable;

    public SetFontColor(Color newfontColor, TextStyleChangeable textStyleChangeable, CommandManager commandManager) {
        this.textStyleChangeable = textStyleChangeable;
        this.newfontColor = newfontColor;
        this.oldfontColor = textStyleChangeable.getTextStyle().getFontColor();
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        TextStyle ots = this.textStyleChangeable.getTextStyle();
        TextStyle newTextStyle = TextStyleFactory.getInstance().getTextStyle(ots.getFontName(), ots.getSize(), this.newfontColor, ots.isUnderlined(), ots.isBold(), ots.isItalic());
        this.textStyleChangeable.setTextStyle(newTextStyle);
        return true;
    }

    @Override
    public final boolean undoIt() {
        TextStyle ots = this.textStyleChangeable.getTextStyle();
        TextStyle newTextStyle = TextStyleFactory.getInstance().getTextStyle(ots.getFontName(), ots.getSize(), this.oldfontColor, ots.isUnderlined(), ots.isBold(), ots.isItalic());
        this.textStyleChangeable.setTextStyle(newTextStyle);
        return false;
    }
}

