/*
 * Decompiled with CFR 0.152.
 */
package commands.changetext;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.text.AttributedText;
import document.text.TextFieldController;
import document.text.TextStyle;
import document.text.chunks.Chunk;
import document.text.menutext.TextMenu;
import java.util.ArrayList;

public class InsertTextWithMenusCommand
extends AbstractCommand {
    private int insertPosition;
    private String text = "";
    private int textToClearBegin;
    private int textToClearEnd;
    private ArrayList<Chunk> textToClear = null;
    private int cursorBefore;
    private int cursorAfter;
    private TextFieldController controller;
    private TextStyle textStyle;
    TextMenu textMenu;

    public InsertTextWithMenusCommand(int position, int cursorBefore, int cursorAfter, int textToClearBegin, int textToClearEnd, String text, TextStyle textStyle, TextFieldController controller, CommandManager commandManager, TextMenu textMenu) {
        this.insertPosition = position;
        this.cursorBefore = cursorBefore;
        this.cursorAfter = cursorAfter;
        this.textStyle = textStyle;
        this.textMenu = textMenu;
        this.textToClearBegin = textToClearBegin;
        this.textToClearEnd = textToClearEnd;
        if (this.textToClearBegin > this.textToClearEnd) {
            int z = this.textToClearBegin;
            this.textToClearBegin = this.textToClearEnd;
            this.textToClearEnd = z;
        }
        if (this.textToClearBegin != this.textToClearEnd) {
            this.insertPosition = this.textToClearBegin;
            this.cursorAfter = this.insertPosition + text.length();
        }
        this.text = text;
        this.controller = controller;
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        if (this.textToClearBegin != this.textToClearEnd) {
            this.textToClear = attributedText.deleteSubText(attributedText.intToChunkPosition(this.textToClearBegin), attributedText.intToChunkPosition(this.textToClearEnd));
        }
        attributedText.insertTextWithMenus(this.text, attributedText.intToChunkPosition(this.insertPosition), this.textStyle);
        this.controller.setMarkingActive(false);
        this.controller.setMarkStart(0);
        this.controller.setMarkEnd(0);
        this.controller.setCursor(this.cursorAfter);
        return true;
    }

    @Override
    public final boolean undoIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        if (this.text.length() > 0) {
            attributedText.deleteSubText(attributedText.intToChunkPosition(this.insertPosition), attributedText.intToChunkPosition(this.insertPosition + this.text.length()));
        }
        if (this.textToClear != null) {
            attributedText.insertAt(this.textToClear, attributedText.intToChunkPosition(this.textToClearBegin));
        }
        if (this.textToClearBegin != this.textToClearEnd) {
            this.controller.setMarkingActive(true);
            this.controller.setMarkStart(this.textToClearBegin);
            this.controller.setMarkEnd(this.textToClearEnd);
        }
        this.controller.setCursor(this.cursorBefore);
        return false;
    }
}

