/*
 * Decompiled with CFR 0.152.
 */
package commands.objectaligngroupzorder;

import commands.baseclasses.AbstractCommand;
import document.MyObject;
import document.MyPage;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import java.util.ArrayList;
import java.util.Collections;

public abstract class ObjectsForegroundBackgroundCommand
extends AbstractCommand {
    private MarkedObjectsAndHandles stateInfo;
    private ArrayList<ObjectZOrderInformation> zOrderInformation = new ArrayList();
    private MyPage page;
    private static boolean sortAccordingToOldZOrder = false;

    public ObjectsForegroundBackgroundCommand(MarkedObjectsAndHandles stateInfo) {
        this.stateInfo = stateInfo;
        this.page = stateInfo.getMarkedObjectsPageController().getPage();
        for (MyObject object : stateInfo.getMarkedObjects().getObjects()) {
            ObjectZOrderInformation ozi = new ObjectZOrderInformation(object, object.getPage().getZOrder(object));
            this.getZOrderInformation().add(ozi);
        }
        if (this.getZOrderInformation().size() > 0) {
            ObjectsForegroundBackgroundCommand.setSortAccordingToOldZOrder(true);
            Collections.sort(this.getZOrderInformation());
            this.setNewZOrder(this.page.getObjects().size());
            this.page.getDocument().getCommandManager().invokeCommand(this);
        }
    }

    protected abstract void setNewZOrder(int var1);

    @Override
    public final boolean doIt() {
        for (ObjectZOrderInformation zoi : this.getZOrderInformation()) {
            this.page.removeObject(zoi.object);
        }
        ObjectsForegroundBackgroundCommand.setSortAccordingToOldZOrder(false);
        Collections.sort(this.getZOrderInformation());
        for (ObjectZOrderInformation zoi : this.getZOrderInformation()) {
            this.page.addObject(zoi.getNewZOrderInPage(), zoi.object);
        }
        return true;
    }

    @Override
    public final boolean undoIt() {
        for (ObjectZOrderInformation zoi : this.getZOrderInformation()) {
            this.page.removeObject(zoi.object);
        }
        ObjectsForegroundBackgroundCommand.setSortAccordingToOldZOrder(true);
        Collections.sort(this.getZOrderInformation());
        for (ObjectZOrderInformation zoi : this.getZOrderInformation()) {
            this.page.addObject(zoi.getOldZOrderInPage(), zoi.object);
        }
        return false;
    }

    protected final void setZOrderInformation(ArrayList<ObjectZOrderInformation> zOrderInformation) {
        this.zOrderInformation = zOrderInformation;
    }

    protected final ArrayList<ObjectZOrderInformation> getZOrderInformation() {
        return this.zOrderInformation;
    }

    static void setSortAccordingToOldZOrder(boolean sortAccordingToOldZOrder) {
        ObjectsForegroundBackgroundCommand.sortAccordingToOldZOrder = sortAccordingToOldZOrder;
    }

    static boolean isSortAccordingToOldZOrder() {
        return sortAccordingToOldZOrder;
    }

    public final MarkedObjectsAndHandles getStateInfo() {
        return this.stateInfo;
    }

    protected class ObjectZOrderInformation
    implements Comparable<ObjectZOrderInformation> {
        private MyObject object;
        private int oldZOrderInPage;
        private int newZOrderInPage;

        public ObjectZOrderInformation(MyObject object, int oldZOrderInPage) {
            this.object = object;
            this.setOldZOrderInPage(oldZOrderInPage);
        }

        @Override
        public final int compareTo(ObjectZOrderInformation o) {
            if (ObjectsForegroundBackgroundCommand.isSortAccordingToOldZOrder()) {
                return this.getOldZOrderInPage() - o.getOldZOrderInPage();
            }
            return this.getNewZOrderInPage() - o.getNewZOrderInPage();
        }

        public final void setNewZOrderInPage(int newZOrderInPage) {
            this.newZOrderInPage = newZOrderInPage;
        }

        public final int getNewZOrderInPage() {
            return this.newZOrderInPage;
        }

        public final void setOldZOrderInPage(int oldZOrderInPage) {
            this.oldZOrderInPage = oldZOrderInPage;
        }

        public final int getOldZOrderInPage() {
            return this.oldZOrderInPage;
        }
    }
}

