/*
 * Decompiled with CFR 0.152.
 */
package data.localdatabase;

import data.DataObject;
import data.localdatabase.DBKlassenDaten;
import data.localdatabase.DBSchuelerDaten;
import data.localdatabase.DBSchuelerZeugnisDaten;
import data.localdatabase.DBSchulDaten;
import data.localdatabase.DBUserDaten;
import data.localdatabase.DBZeugnisDaten;
import data.localdatabase.Zeugnisvorlage;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class DBExchangeObject
extends DataObject {
    private DBUserDaten currentlyLoggedInUser;
    private String databasePassword;
    private ArrayList<DBSchulDaten> schulen = new ArrayList();
    private String schulXMLIndices;
    private ArrayList<DBUserDaten> users = new ArrayList();
    private String userXMLIndices;
    private String currentSchoolyear = null;

    public String getSchuljahr() {
        this.currentSchoolyear = this.currentSchoolyear == null && DBExchangeObject.getDatabaseInterface() != null ? DBExchangeObject.getDatabaseInterface().getCurrentSchoolyear() : "2008/09";
        return this.currentSchoolyear;
    }

    public DBUserDaten getCurrentlyLoggedInUser() {
        this.retrieveDataFromDatabase();
        return this.currentlyLoggedInUser;
    }

    public void setCurrentlyLoggedInUser(DBUserDaten currentlyLoggedInUser) {
        this.currentlyLoggedInUser = currentlyLoggedInUser;
    }

    public String getDatabasePassword() {
        this.retrieveDataFromDatabase();
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public ArrayList<DBSchulDaten> getSchulen(DBUserDaten user) {
        this.retrieveDataFromDatabase();
        ArrayList<DBSchulDaten> userSchulen = new ArrayList<DBSchulDaten>();
        for (DBSchulDaten schule : this.schulen) {
            if (!schule.getUsers().contains(user)) continue;
            userSchulen.add(schule);
        }
        return userSchulen;
    }

    @Override
    public void cleanbuffer() {
    }

    @Override
    protected ArrayList<DataObject> getBufferedObjects() {
        return null;
    }

    @Override
    protected int getMaxBufferedObjects() {
        return 0;
    }

    @Override
    protected void retrieveDataFromDatabase() {
        this.retrieveDataFromDatabaseHelper(false);
    }

    public void retrieveDataFromDatabaseHelper(boolean dataForSeveralUsers) {
        if (DBExchangeObject.getDatabaseInterface() != null) {
            if (this.currentlyLoggedInUser == null) {
                this.currentlyLoggedInUser = new DBUserDaten();
                this.currentlyLoggedInUser.setIndex(DBExchangeObject.getDatabaseInterface().getCurrentUserIndex());
            }
            if (dataForSeveralUsers) {
                ArrayList<Object> userIndices = DBExchangeObject.getDatabaseInterface().getUserIndicesForDataFile();
                for (Object userIndex : userIndices) {
                    if (this.findUser(userIndex) != null) continue;
                    DBUserDaten userData = new DBUserDaten();
                    userData.setIndex(userIndex);
                    this.users.add(userData);
                }
            }
            if (this.currentlyLoggedInUser != null && this.findUser(this.currentlyLoggedInUser.getIndex()) == null) {
                this.users.add(this.currentlyLoggedInUser);
            }
            for (DBUserDaten userData : this.users) {
                ArrayList<Object> schulindices = DBExchangeObject.getDatabaseInterface().getSchoolIndices(userData.getIndex());
                DBSchulDaten schulData_z = null;
                for (Object schulIndex : schulindices) {
                    boolean exists = false;
                    for (DBSchulDaten schulData : this.schulen) {
                        if (schulData.getIndex() != schulIndex) continue;
                        exists = true;
                        schulData_z = schulData;
                        break;
                    }
                    if (!exists) {
                        schulData_z = new DBSchulDaten(this);
                        schulData_z.setIndex(schulIndex);
                        this.schulen.add(schulData_z);
                    }
                    schulData_z.getUsers().add(userData);
                }
                this.setEmpty(false);
            }
        }
    }

    private DBUserDaten findUser(Object index) {
        for (DBUserDaten user : this.users) {
            if (user.getIndex() != index) continue;
            return user;
        }
        return null;
    }

    @Override
    public void deserialize(Element element) {
        this.currentSchoolyear = XMLReader.attribute(element, "p_currentSchoolyear");
        this.schulXMLIndices = XMLReader.attributeNotNull(element, "p_schulXMLIndices");
        this.userXMLIndices = XMLReader.attributeNotNull(element, "p_userXMLIndices");
        Integer maxXMLIndexI = XMLReader.elementIntegerAttribute(element, "p_maxXMLIndex");
        int maxXMLIndex = 0;
        if (maxXMLIndexI != null) {
            maxXMLIndex = maxXMLIndexI;
        }
        DataObject.prepareArrayForDeserializedObjects(maxXMLIndex + 1);
        this.deserializeKeyValuePairs(element);
        Element schulenElement = XMLReader.element(element, "schulliste");
        Element userElement = XMLReader.element(element, "userliste");
        Element klassenElement = XMLReader.element(element, "klassenliste");
        Element schuelerElement = XMLReader.element(element, "schuelerliste");
        Element schuelerZeugnisElement = XMLReader.element(element, "schuelerZeugnisse");
        Element zeugnisElement = XMLReader.element(element, "zeugnisListe");
        Element zeugnisvorlageElement = XMLReader.element(element, "zeugnisVorlagen");
        new DBSchulDaten(this).deserializeListOfDataObjects(schulenElement);
        new DBUserDaten().deserializeListOfDataObjects(userElement);
        new DBKlassenDaten(null).deserializeListOfDataObjects(klassenElement);
        new DBSchuelerDaten(null).deserializeListOfDataObjects(schuelerElement);
        new DBSchuelerZeugnisDaten(null, null).deserializeListOfDataObjects(schuelerZeugnisElement);
        new DBZeugnisDaten().deserializeListOfDataObjects(zeugnisElement);
        new Zeugnisvorlage().deserializeListOfDataObjects(zeugnisvorlageElement);
        DataObject.resolveAllXMLIndices();
        DataObject.deleteArrayForDeserializedObjects();
        if (this.users.size() > 0) {
            this.currentlyLoggedInUser = this.users.get(0);
        }
    }

    @Override
    public void serialize(Element parentElement) {
        this.retrieveDataFromDatabaseHelper(true);
        Element element = XMLWriter.addElement(DBExchangeObject.getXMLName(), parentElement);
        XMLWriter.addAttribute(element, "p_currentSchoolyear", this.getSchuljahr());
        this.serializeKeyValuePairs(element);
        this.setIndex(0);
        int index = 1;
        for (DBSchulDaten schule : this.schulen) {
            schule.setXMLIndex(index++);
            for (DBKlassenDaten dBKlassenDaten : schule.getClasses()) {
                dBKlassenDaten.setXMLIndex(index++);
                for (DBSchuelerDaten schueler : dBKlassenDaten.getSchueler()) {
                    schueler.setXMLIndex(index++);
                    for (DBSchuelerZeugnisDaten schuelerZeugnis : schueler.getZeugnisse()) {
                        schuelerZeugnis.setXMLIndex(index++);
                    }
                }
                for (DBZeugnisDaten zeugnis : dBKlassenDaten.getZeugnisse()) {
                    zeugnis.setXMLIndex(index++);
                    zeugnis.getZeugnisVorlage();
                }
            }
        }
        for (DBUserDaten user : this.users) {
            user.setXMLIndex(index++);
        }
        ArrayList<Zeugnisvorlage> zeugnisvorlagen = Zeugnisvorlage.getZeugnisVorlagen();
        for (Zeugnisvorlage zeugnisvorlage : zeugnisvorlagen) {
            zeugnisvorlage.setXMLIndex(index++);
        }
        int maxIndex = index - 1;
        XMLWriter.addAttributeInt(element, "p_maxXMLIndex", maxIndex);
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < this.schulen.size()) {
            stringBuffer.append(this.schulen.get(i).getXMLIndex());
            if (i < this.schulen.size() - 1) {
                stringBuffer.append(',');
            }
            ++i;
        }
        XMLWriter.addAttribute(element, "p_schulXMLIndices", stringBuffer.toString());
        StringBuffer stringBuffer2 = new StringBuffer();
        i = 0;
        while (i < this.users.size()) {
            stringBuffer2.append(this.users.get(i).getXMLIndex());
            if (i < this.users.size() - 1) {
                stringBuffer2.append(',');
            }
            ++i;
        }
        XMLWriter.addAttribute(element, "p_userXMLIndices", stringBuffer2.toString());
        Element schulenElement = XMLWriter.addElement("schulliste", element);
        Element userElement = XMLWriter.addElement("userliste", element);
        Element klassenElement = XMLWriter.addElement("klassenliste", element);
        Element schuelerElement = XMLWriter.addElement("schuelerliste", element);
        Element schuelerZeugnisElement = XMLWriter.addElement("schuelerZeugnisse", element);
        Element zeugnisElement = XMLWriter.addElement("zeugnisListe", element);
        Element zeugnisVorlageElement = XMLWriter.addElement("zeugnisVorlagen", element);
        for (DBSchulDaten schule : this.schulen) {
            schule.serialize(schulenElement);
            for (DBKlassenDaten klasse : schule.getClasses()) {
                klasse.serialize(klassenElement);
                for (DBSchuelerDaten schueler : klasse.getSchueler()) {
                    schueler.serialize(schuelerElement);
                    for (DBSchuelerZeugnisDaten schuelerZeugnis : schueler.getZeugnisse()) {
                        schuelerZeugnis.serialize(schuelerZeugnisElement);
                    }
                }
                for (DBZeugnisDaten zeugnis : klasse.getZeugnisse()) {
                    zeugnis.serialize(zeugnisElement);
                }
            }
        }
        for (DBUserDaten user : this.users) {
            user.serialize(userElement);
        }
        for (Zeugnisvorlage zeugnisvorlage : zeugnisvorlagen) {
            zeugnisvorlage.serialize(zeugnisVorlageElement);
        }
    }

    public static String getXMLName() {
        return "Exchange";
    }

    @Override
    public DataObject getNewInstance() {
        return new DBExchangeObject();
    }

    @Override
    public void resolveXMLIndices() {
        this.schulen.clear();
        ArrayList<Integer> numbers = this.StringListToInt(this.schulXMLIndices);
        for (Integer number : numbers) {
            this.schulen.add((DBSchulDaten)DBExchangeObject.getDeserializedObject(number));
        }
        this.users.clear();
        numbers = this.StringListToInt(this.userXMLIndices);
        for (Integer number : numbers) {
            this.users.add((DBUserDaten)DBExchangeObject.getDeserializedObject(number));
        }
    }
}

