/*
 * Decompiled with CFR 0.152.
 */
package data.localdatabase;

import data.DataObject;
import data.localdatabase.DBKlassenDaten;
import data.localdatabase.DBSchuelerZeugnisDaten;
import data.localdatabase.DBZeugnisDaten;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class DBSchuelerDaten
extends DataObject {
    private static int MAXNUMBEROFBUFFEREDOBJECTS = 5;
    private static ArrayList<DataObject> bufferedObjects = new ArrayList();
    private DBKlassenDaten klasse;
    private int klasseXMLIndex;
    private ArrayList<DBSchuelerZeugnisDaten> zeugnisse = new ArrayList();
    private String zeugnisXMLIndices;

    public DBSchuelerDaten(DBKlassenDaten klasse) {
        this.klasse = klasse;
    }

    public DBKlassenDaten getKlasse() {
        return this.klasse;
    }

    public ArrayList<DBSchuelerZeugnisDaten> getZeugnisse() {
        this.fetchData();
        return this.zeugnisse;
    }

    public DBSchuelerZeugnisDaten getSchuelerZeugnis(DBZeugnisDaten zeugnis) {
        DBSchuelerZeugnisDaten sz2;
        for (DBSchuelerZeugnisDaten sz2 : this.getZeugnisse()) {
            if (sz2.getZeugnis() != zeugnis) continue;
            return sz2;
        }
        sz2 = new DBSchuelerZeugnisDaten(this, zeugnis);
        if (DBSchuelerDaten.getDatabaseInterface() != null) {
            Object schuelerZeugnisIndex = DBSchuelerDaten.getDatabaseInterface().getSchuelerZeugnisIndex(this.getIndex(), zeugnis.getStringValueNotNull("art"), DBSchuelerDaten.getDatabaseInterface().getCurrentSchoolyear());
            sz2.setIndex(schuelerZeugnisIndex);
        }
        this.zeugnisse.add(sz2);
        return sz2;
    }

    @Override
    public void cleanbuffer() {
        String name = this.getStringValueNotNull("name");
        String vorname = this.getStringValueNotNull("vorname");
        String geschlecht = this.getStringValueNotNull("geschlecht");
        this.clear();
        this.put("name", name);
        this.put("vorname", vorname);
        this.put("geschlecht", geschlecht);
    }

    @Override
    protected ArrayList<DataObject> getBufferedObjects() {
        return bufferedObjects;
    }

    @Override
    protected int getMaxBufferedObjects() {
        return MAXNUMBEROFBUFFEREDOBJECTS;
    }

    @Override
    protected void retrieveDataFromDatabase() {
        if (DBSchuelerDaten.getDatabaseInterface() != null) {
            this.clear();
            DBSchuelerDaten.getDatabaseInterface().getPupilData(this.getIndex(), this);
            this.setEmpty(false);
        }
    }

    @Override
    public void deserialize(Element element) {
        this.deserializeKeyValuePairs(element);
        this.klasseXMLIndex = XMLReader.elementIntegerAttribute(element, "klasse");
        this.zeugnisXMLIndices = XMLReader.attributeNotNull(element, "p_zeugnisseXMLIndices");
    }

    @Override
    public DataObject getNewInstance() {
        return new DBSchuelerDaten(null);
    }

    @Override
    public void resolveXMLIndices() {
        this.klasse = (DBKlassenDaten)DBSchuelerDaten.getDeserializedObject(this.klasseXMLIndex);
        this.zeugnisse.clear();
        ArrayList<Integer> numbers = this.StringListToInt(this.zeugnisXMLIndices);
        for (Integer number : numbers) {
            this.zeugnisse.add((DBSchuelerZeugnisDaten)DBSchuelerDaten.getDeserializedObject(number));
        }
    }

    @Override
    public void serialize(Element parentElement) {
        Element element = XMLWriter.addElement(this.getXMLName(), parentElement);
        this.serializeKeyValuePairs(element);
        XMLWriter.addAttributeInt(element, "klasse", this.klasse.getXMLIndex());
        StringBuffer indexBuffer = new StringBuffer();
        int i = 0;
        while (i < this.zeugnisse.size()) {
            indexBuffer.append(this.zeugnisse.get(i).getXMLIndex());
            if (i < this.zeugnisse.size() - 1) {
                indexBuffer.append(',');
            }
            ++i;
        }
        XMLWriter.addAttribute(element, "p_zeugnisseXMLIndices", indexBuffer.toString());
    }

    public String getXMLName() {
        return "schueler";
    }
}

