/*
 * Decompiled with CFR 0.152.
 */
package document;

import document.MyObject;
import document.Renderable;
import document.Serializable;
import document.events.Eventtype;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.graphiccontext.GraphicContext;
import gui.components.pageviewport.handles.HandleController;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.io.ImageStorer;
import util.logging.Log;
import util.math.MyMath;
import util.math.PointDouble;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class MyImage
extends MyObject
implements Renderable,
Serializable {
    private ImageStorer imageStorer = new ImageStorer();

    public static String getXMLName() {
        return "image";
    }

    public MyImage() {
        this(1.0, 1.0, 1.0, 1.0, 0.0);
    }

    public MyImage(double midx, double midy, double width, double height, double angle) {
        this.midX = midx;
        this.midY = midy;
        this.width = width;
        this.height = height;
        this.angle = angle;
        this.makeShape();
    }

    @Override
    public void copyTo(MyObject object) {
        MyImage im = (MyImage)object;
        im.imageStorer = this.imageStorer;
        super.copyTo(object);
    }

    @Override
    public Renderable.ObjectType getType() {
        return Renderable.ObjectType.image;
    }

    @Override
    public boolean isInside(PointDouble pPage) {
        if (this.isInBoundigBox(pPage)) {
            boolean inStroke;
            PointDouble pz = pPage.getCopy();
            MyMath.rotate(pz, this.midX, this.midY, -this.angle);
            double x = pz.getX();
            double y = pz.getY();
            double halfStrokeWidth = this.getStrokeWidth() / 2.0;
            if (halfStrokeWidth < 0.05) {
                halfStrokeWidth = 0.05;
            }
            boolean inPaint = x >= this.midX - this.width / 2.0 && x <= this.midX + this.width / 2.0 && y >= this.midY - this.height / 2.0 && y <= this.midY + this.height / 2.0;
            boolean bl = inStroke = y >= this.midY - this.height / 2.0 - halfStrokeWidth && y <= this.midY + this.height / 2.0 + halfStrokeWidth && (x >= this.midX - this.width / 2.0 - halfStrokeWidth && x <= this.midX - this.width / 2.0 + halfStrokeWidth || x >= this.midX + this.width / 2.0 - halfStrokeWidth && x <= this.midX + this.width / 2.0 + halfStrokeWidth) || x >= this.midX - this.width / 2.0 - halfStrokeWidth && x <= this.midX + this.width / 2.0 + halfStrokeWidth && (y >= this.midY - this.height / 2.0 - halfStrokeWidth && y <= this.midY - this.height / 2.0 + halfStrokeWidth || y >= this.midY + this.height / 2.0 - halfStrokeWidth && y <= this.midY + this.height / 2.0 + halfStrokeWidth);
            return inPaint || this.isStroked() && inStroke;
        }
        return false;
    }

    @Override
    protected void makeShape() {
        this.shape = new Rectangle2D.Double(this.midX - this.width / 2.0, this.midY - this.height / 2.0, this.width, this.height);
    }

    @Override
    public MyObject getCopy() {
        MyImage object = new MyImage(0.0, 0.0, 0.0, 0.0, 0.0);
        this.copyTo(object);
        return object;
    }

    @Override
    public void getHandles(ArrayList<HandleController> handleList, PageViewport pageViewPort) {
        this.getDiagonalStretchingHandles(handleList, pageViewPort, true);
        this.getHorVertStretchingHandles(handleList, pageViewPort);
        this.getRotateHandle(handleList, pageViewPort);
    }

    @Override
    public void render(GraphicContext gc, boolean isPreview) {
        BufferedImage image;
        AffineTransform OldTransform = gc.getTransform();
        gc.setPageCoordinates();
        if (Math.abs(this.getAngle()) > 1.0E-4) {
            gc.rotate(-this.getAngle(), this.getMidX(), this.getMidY());
        }
        if (this.isStroked()) {
            this.setStroke(gc);
            gc.draw(this.getShape());
        }
        if ((image = this.imageStorer.getBufferedImage()) != null) {
            double factorX = this.width / (double)((Image)image).getWidth(null);
            double factorY = this.height / (double)((Image)image).getHeight(null);
            AffineTransform at = new AffineTransform();
            at.setToIdentity();
            at.translate(this.midX - this.width / 2.0, this.midY - this.height / 2.0);
            at.scale(factorX, factorY);
            gc.drawImage(image, at, null);
        }
        gc.setTransform(OldTransform);
    }

    @Override
    public void deSerialize(Element element) {
        String resourceName = XMLReader.attribute(element, "imageresourcename");
        if (resourceName != null) {
            this.imageStorer = this.getDocument().getImageStorerResource(resourceName);
        } else {
            Log.log(3, "MyImage.deSerialize: Image resource not found.");
        }
        super.deSerialize(element);
        this.makeShape();
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(MyImage.getXMLName(), parentElement);
        XMLWriter.addAttribute(element, "imageresourcename", this.getDocument().addImageStorerResource(this.imageStorer));
        super.serialize(element);
        return element;
    }

    public void readImageFromFile(File file) throws IOException {
        this.imageStorer.readFromFile(file);
        BufferedImage bi = this.imageStorer.getBufferedImage();
        if (bi != null) {
            double pixelwidth = bi.getWidth();
            double pixelheight = bi.getHeight();
            this.width = pixelwidth / 300.0 * 2.54;
            this.height = pixelheight / 300.0 * 2.54;
            this.midX = this.width / 2.0 + 2.0;
            this.midY = this.height / 2.0 + 2.0;
            this.makeShape();
        }
    }

    @Override
    public Eventtype[] getPossibleEvents() {
        return null;
    }
}

