/*
 * Decompiled with CFR 0.152.
 */
package document;

import bsh.EvalError;
import bsh.Interpreter;
import data.scripting.DocumentScriptingContext;
import data.scripting.ScriptableObject;
import document.MyDocument;
import document.MyLineStyle;
import document.MyPage;
import document.Renderable;
import document.Scriptable;
import document.Serializable;
import document.events.Eventtype;
import document.events.Script;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.autoarrange.SnapPositions;
import gui.components.pageviewport.graphiccontext.GraphicContext;
import gui.components.pageviewport.handles.DiagonalStretchHandleController;
import gui.components.pageviewport.handles.HandleController;
import gui.components.pageviewport.handles.HorVertStretchHandleController;
import gui.components.pageviewport.handles.MoveHandleController;
import gui.components.pageviewport.handles.RotateHandleController;
import gui.icons.ViewportIcon;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.math.MyMath;
import util.math.PointDouble;
import util.math.RectangleDouble;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public abstract class MyObject
implements Renderable,
Serializable,
Scriptable {
    private static int nextObjectIndex = 1;
    private int index = -1;
    private EditingAllowedInFillinModus isEditingAllowedInFillinModus = EditingAllowedInFillinModus.denied;
    private MyLineStyle lineStyle = new MyLineStyle();
    protected MyObject previewObject = null;
    private boolean isPreviewObject = false;
    protected static int handleDistance = 14;
    private static int rotationHandleDistance = 60;
    protected MyPage page;
    protected double midX;
    protected double midY;
    protected double width;
    protected double height;
    protected double angle;
    protected Shape shape;
    private ArrayList<ViewportIcon> icons = new ArrayList();
    private ArrayList<Script> scripts = null;

    public abstract void getHandles(ArrayList<HandleController> var1, PageViewport var2);

    public void makePreview() {
        this.previewObject = this.getCopy();
        this.previewObject.setPreviewObject(true);
    }

    public boolean hasPreview() {
        return this.previewObject != null;
    }

    public void releasePreview() {
        this.previewObject = null;
    }

    public void getRotateHandle(ArrayList<HandleController> handleList, PageViewport pageViewPort) {
        double dx = this.width / 2.0 + pageViewPort.pixelTocmX(rotationHandleDistance);
        double handleAngle = 0.0;
        double x = this.midX + dx;
        double y = this.midY;
        handleAngle = this.angle;
        PointDouble HandleMid = new PointDouble(x, y);
        MyMath.rotate(HandleMid, this.midX, this.midY, this.angle);
        if (HandleMid.x < 0.0 || HandleMid.x > this.page.getWidthcm() || HandleMid.y < 0.0 || HandleMid.y > this.page.getHeightcm()) {
            x = this.midX - dx;
            handleAngle = this.angle + Math.PI;
            HandleMid = new PointDouble(x, y);
            MyMath.rotate(HandleMid, this.midX, this.midY, this.angle);
        }
        int xPanel = pageViewPort.pageCmXtoPixel(HandleMid.getX(), this.page);
        int yPanel = pageViewPort.pageCmYtoPixel(HandleMid.getY(), this.page);
        RotateHandleController handle = new RotateHandleController(this, xPanel, yPanel, handleAngle, pageViewPort);
        handleList.add(handle);
    }

    public void getMoveHandle(ArrayList<HandleController> handleList, PageViewport pageViewPort) {
        double dx = this.width / 2.0 + pageViewPort.pixelTocmX(rotationHandleDistance);
        double dy = this.height / 2.0;
        double x = this.midX + dx;
        double y = this.midY - dy;
        double handleAngle = this.angle;
        PointDouble HandleMid = new PointDouble(x, y);
        MyMath.rotate(HandleMid, this.midX, this.midY, this.angle);
        if (HandleMid.x < 0.0 || HandleMid.x > this.page.getWidthcm() || HandleMid.y < 0.0 || HandleMid.y > this.page.getHeightcm()) {
            x = this.midX - dx;
            handleAngle = this.angle + Math.PI;
            HandleMid = new PointDouble(x, y);
            MyMath.rotate(HandleMid, this.midX, this.midY, this.angle);
        }
        int xPanel = pageViewPort.pageCmXtoPixel(HandleMid.getX(), this.page);
        int yPanel = pageViewPort.pageCmYtoPixel(HandleMid.getY(), this.page);
        MoveHandleController handle = new MoveHandleController(this, xPanel, yPanel, handleAngle, pageViewPort);
        handleList.add(handle);
    }

    public void getHandle(ArrayList<HandleController> handleList, PageViewport pageViewPort, boolean isPreservingSimilarity, HandleDirection handleDirection) {
        double strokeWidthHalf = this.getStrokeWidth() / 2.0;
        double dx = this.width / 2.0 + strokeWidthHalf + pageViewPort.pixelTocmX(handleDistance);
        double dy = this.height / 2.0 + strokeWidthHalf + pageViewPort.pixelTocmY(handleDistance);
        double dhor = this.width / 2.0 + strokeWidthHalf + pageViewPort.pixelTocmX(handleDistance) * 1.4;
        double dvert = this.height / 2.0 + strokeWidthHalf + pageViewPort.pixelTocmY(handleDistance) * 1.4;
        double dxref = this.width / 2.0;
        double dyref = this.height / 2.0;
        double x = 0.0;
        double y = 0.0;
        double xref = 0.0;
        double yref = 0.0;
        double handleAngle = 0.0;
        switch (handleDirection) {
            case topleft: {
                x = this.midX - dx;
                xref = this.midX - dxref;
                y = this.midY - dy;
                yref = this.midY - dyref;
                handleAngle = 2.356194490192345;
                break;
            }
            case topright: {
                x = this.midX + dx;
                xref = this.midX + dxref;
                y = this.midY - dy;
                yref = this.midY - dyref;
                handleAngle = 0.7853981633974483;
                break;
            }
            case bottomleft: {
                x = this.midX - dx;
                xref = this.midX - dxref;
                y = this.midY + dy;
                yref = this.midY + dyref;
                handleAngle = -2.356194490192345;
                break;
            }
            case bottomright: {
                x = this.midX + dx;
                xref = this.midX + dxref;
                y = this.midY + dy;
                yref = this.midY + dyref;
                handleAngle = -0.7853981633974483;
                break;
            }
            case left: {
                x = this.midX - dhor;
                xref = this.midX - dxref;
                y = this.midY;
                yref = this.midY;
                handleAngle = Math.PI;
                break;
            }
            case right: {
                x = this.midX + dhor;
                xref = this.midX + dxref;
                y = this.midY;
                yref = this.midY;
                handleAngle = 0.0;
                break;
            }
            case bottom: {
                x = this.midX;
                xref = this.midX;
                y = this.midY + dvert;
                yref = this.midY + dyref;
                handleAngle = -1.5707963267948966;
                break;
            }
            case top: {
                x = this.midX;
                xref = this.midX;
                y = this.midY - dvert;
                yref = this.midY - dyref;
                handleAngle = 1.5707963267948966;
                break;
            }
        }
        handleAngle += this.angle;
        PointDouble HandleMid = new PointDouble(x, y);
        PointDouble referencedPoint = new PointDouble(xref, yref);
        MyMath.rotate(HandleMid, this.midX, this.midY, this.angle);
        MyMath.rotate(referencedPoint, this.midX, this.midY, this.angle);
        int xPanel = pageViewPort.pageCmXtoPixel(HandleMid.getX(), this.page);
        int yPanel = pageViewPort.pageCmYtoPixel(HandleMid.getY(), this.page);
        HandleController handle = handleDirection == HandleDirection.bottomleft || handleDirection == HandleDirection.bottomright || handleDirection == HandleDirection.topleft || handleDirection == HandleDirection.topright ? new DiagonalStretchHandleController(this, xPanel, yPanel, handleAngle, referencedPoint, isPreservingSimilarity, pageViewPort) : (handleDirection == HandleDirection.top || handleDirection == HandleDirection.bottom ? new HorVertStretchHandleController(this, xPanel, yPanel, handleAngle, referencedPoint, HorVertStretchHandleController.Direction.vertical, pageViewPort) : new HorVertStretchHandleController(this, xPanel, yPanel, handleAngle, referencedPoint, HorVertStretchHandleController.Direction.horizontal, pageViewPort));
        handleList.add(handle);
    }

    public void getDiagonalStretchingHandles(ArrayList<HandleController> handleList, PageViewport pageViewPort, boolean isPreservingSimilarity) {
        this.getHandle(handleList, pageViewPort, isPreservingSimilarity, HandleDirection.topleft);
        this.getHandle(handleList, pageViewPort, isPreservingSimilarity, HandleDirection.topright);
        this.getHandle(handleList, pageViewPort, isPreservingSimilarity, HandleDirection.bottomleft);
        this.getHandle(handleList, pageViewPort, isPreservingSimilarity, HandleDirection.bottomright);
    }

    public void getHorVertStretchingHandles(ArrayList<HandleController> handleList, PageViewport pageViewPort) {
        this.getHandle(handleList, pageViewPort, false, HandleDirection.top);
        this.getHandle(handleList, pageViewPort, false, HandleDirection.left);
        this.getHandle(handleList, pageViewPort, false, HandleDirection.bottom);
        this.getHandle(handleList, pageViewPort, false, HandleDirection.right);
    }

    public void stretch(PointDouble center, double factor) {
        PointDouble mid = new PointDouble(this.midX, this.midY);
        mid.stretch(center, factor);
        this.midX = mid.getX();
        this.midY = mid.getY();
        this.width = Math.abs(this.width * factor);
        this.height = Math.abs(this.height * factor);
        this.makeShape();
        if (!this.isPreviewObject) {
            this.setDirty();
        }
    }

    public void stretch(PointDouble center, double factorHor, double factorVert) {
        center = center.getCopy();
        MyMath.rotate(center, this.midX, this.midY, -this.angle);
        PointDouble newMid = new PointDouble((this.midX - center.getX()) * factorHor + center.getX(), (this.midY - center.getY()) * factorVert + center.getY());
        MyMath.rotate(newMid, this.midX, this.midY, this.angle);
        this.midX = newMid.getX();
        this.midY = newMid.getY();
        this.width *= Math.abs(factorHor);
        this.height *= Math.abs(factorVert);
        this.makeShape();
        if (!this.isPreviewObject) {
            this.setDirty();
        }
    }

    public abstract MyObject getCopy();

    public void copyTo(MyObject object) {
        this.lineStyle.copyTo(object.getLineStyle());
        object.page = this.page;
        object.angle = this.angle;
        object.midX = this.midX;
        object.midY = this.midY;
        object.width = this.width;
        object.height = this.height;
        object.isEditingAllowedInFillinModus = this.isEditingAllowedInFillinModus;
        if (this.scripts != null) {
            object.scripts = new ArrayList();
            for (Script script : this.scripts) {
                object.scripts.add(script.getCopy());
            }
        }
        object.makeShape();
    }

    public BasicStroke getStroke() {
        return this.lineStyle.getStroke();
    }

    public double getStrokeWidth() {
        return this.lineStyle.getStrokeWidth();
    }

    public void setStroke(Graphics2D g2d) {
        this.lineStyle.setStroke(g2d);
    }

    public boolean isStroked() {
        return this.getLineStyle().isStroked();
    }

    protected abstract void makeShape();

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
        this.makeShape();
        if (!this.isPreviewObject) {
            this.setDirty();
        }
    }

    public double getMidX() {
        return this.midX;
    }

    public void setMidX(double midX) {
        this.midX = midX;
        this.makeShape();
        if (!this.isPreviewObject) {
            this.setDirty();
        }
    }

    public double getMidY() {
        return this.midY;
    }

    public void setMidY(double midY) {
        this.midY = midY;
        this.makeShape();
        if (!this.isPreviewObject) {
            this.setDirty();
        }
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
        this.makeShape();
        if (!this.isPreviewObject) {
            this.setDirty();
        }
    }

    public double getAngle() {
        return this.angle;
    }

    public double getAngleInDegrees() {
        return this.getAngle() / Math.PI * 180.0;
    }

    public void setAngleInDegrees(double angle) {
        this.setAngle(angle / 180.0 * Math.PI);
        if (!this.isPreviewObject) {
            this.setDirty();
        }
    }

    public void setAngle(double angle) {
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        this.angle = angle;
        this.makeShape();
        if (!this.isPreviewObject) {
            this.setDirty();
        }
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean isInBoundigBox(PointDouble pPage) {
        pPage = pPage.getCopy();
        MyMath.rotate(pPage, this.midX, this.midY, -this.angle);
        double x1 = pPage.getX() - this.midX;
        double y1 = pPage.getY() - this.midY;
        double halfStrokeWidth = this.getStrokeWidth() / 2.0;
        return Math.abs(x1) <= this.width / 2.0 + halfStrokeWidth && Math.abs(y1) <= this.height / 2.0 + halfStrokeWidth;
    }

    public MyPage getPage() {
        return this.page;
    }

    @Override
    public RectangleDouble getBoundingBox() {
        double minX = 100000.0;
        double minY = 100000.0;
        double maxX = -100000.0;
        double maxY = -100000.0;
        PointDouble p = new PointDouble(this.midX - this.width / 2.0, this.midY - this.height / 2.0);
        MyMath.rotate(p, this.midX, this.midY, this.angle);
        minX = MyMath.min(minX, p.getX());
        maxX = MyMath.max(maxX, p.getX());
        minY = MyMath.min(minY, p.getY());
        maxY = MyMath.max(maxY, p.getY());
        p = new PointDouble(this.midX + this.width / 2.0, this.midY - this.height / 2.0);
        MyMath.rotate(p, this.midX, this.midY, this.angle);
        minX = MyMath.min(minX, p.getX());
        maxX = MyMath.max(maxX, p.getX());
        minY = MyMath.min(minY, p.getY());
        maxY = MyMath.max(maxY, p.getY());
        p = new PointDouble(this.midX - this.width / 2.0, this.midY + this.height / 2.0);
        MyMath.rotate(p, this.midX, this.midY, this.angle);
        minX = MyMath.min(minX, p.getX());
        maxX = MyMath.max(maxX, p.getX());
        minY = MyMath.min(minY, p.getY());
        maxY = MyMath.max(maxY, p.getY());
        p = new PointDouble(this.midX + this.width / 2.0, this.midY + this.height / 2.0);
        MyMath.rotate(p, this.midX, this.midY, this.angle);
        minX = MyMath.min(minX, p.getX());
        maxX = MyMath.max(maxX, p.getX());
        minY = MyMath.min(minY, p.getY());
        maxY = MyMath.max(maxY, p.getY());
        return new RectangleDouble(minX, minY, maxX, maxY);
    }

    public static int getHandleDistance() {
        return handleDistance;
    }

    public MyObject getPreviewObject() {
        return this.previewObject;
    }

    public void copyToPreviewObject() {
        if (this.previewObject == null) {
            this.makePreview();
        }
        this.copyTo(this.previewObject);
    }

    public void move(double dx, double dy) {
        this.midX += dx;
        this.midY += dy;
        this.makeShape();
        if (!this.isPreviewObject) {
            this.setDirty();
        }
    }

    public void setPage(MyPage page) {
        this.page = page;
        if (!this.isPreviewObject) {
            this.setDirty();
        }
    }

    public void rotate(PointDouble center, double angle) {
        PointDouble pMid = new PointDouble(this.midX, this.midY);
        MyMath.rotate(pMid, center.getX(), center.getY(), angle);
        this.midX = pMid.getX();
        this.midY = pMid.getY();
        this.angle += angle;
        this.angle = MyMath.normalizeAngle(this.angle);
        this.makeShape();
        if (!this.isPreviewObject) {
            this.setDirty();
        }
    }

    public void getSnapPositions(SnapPositions snapPositions) {
        if (Math.abs(this.angle / 1.5707963267948966 - (double)((int)(this.angle / 1.5707963267948966))) < 1.0E-6) {
            double lHeight;
            double lWidth;
            long quadrant = Math.round(this.angle / 1.5707963267948966) % 4L + 1L;
            if (quadrant % 2L == 1L) {
                lWidth = this.width;
                lHeight = this.height;
            } else {
                lWidth = this.height;
                lHeight = this.width;
            }
            snapPositions.addPosition(this.midX - lWidth / 2.0, this.midY, SnapPositions.Type.horizontal, this);
            snapPositions.addPosition(this.midX + lWidth / 2.0, this.midY, SnapPositions.Type.horizontal, this);
            snapPositions.addPosition(this.midX, this.midY + lHeight / 2.0, SnapPositions.Type.vertical, this);
            snapPositions.addPosition(this.midX, this.midY - lHeight / 2.0, SnapPositions.Type.vertical, this);
            snapPositions.addPosition(this.midX, this.midY, SnapPositions.Type.horizontalCenter, this);
            snapPositions.addPosition(this.midX, this.midY, SnapPositions.Type.verticalCenter, this);
            snapPositions.addPosition(this.midX - lWidth / 2.0, this.midY + lHeight / 2.0, SnapPositions.Type.point, this);
            snapPositions.addPosition(this.midX - lWidth / 2.0, this.midY - lHeight / 2.0, SnapPositions.Type.point, this);
            snapPositions.addPosition(this.midX + lWidth / 2.0, this.midY + lHeight / 2.0, SnapPositions.Type.point, this);
            snapPositions.addPosition(this.midX + lWidth / 2.0, this.midY - lHeight / 2.0, SnapPositions.Type.point, this);
            snapPositions.addPosition(this.midX, this.midY, SnapPositions.Type.point, this);
        }
    }

    public void moveTo(PointDouble newMid) {
        this.midX = newMid.getX();
        this.midY = newMid.getY();
        this.makeShape();
        if (!this.isPreviewObject) {
            this.setDirty();
        }
    }

    public MyDocument getDocument() {
        return this.page.getDocument();
    }

    public MyLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(MyLineStyle lineStyle) {
        this.lineStyle = lineStyle;
        if (!this.isPreviewObject) {
            this.setDirty();
        }
    }

    public PointDouble pageCoordinatesToObjectCoordinates(PointDouble p) {
        p = p.getCopy();
        p.sub(new PointDouble(this.midX, this.midY));
        MyMath.rotate(p, 0.0, 0.0, -this.angle);
        p.add(new PointDouble(this.width / 2.0, this.height / 2.0));
        return p;
    }

    public PointDouble objectCoordinatesToPageCoordinates(PointDouble p) {
        p = p.getCopy();
        p.sub(new PointDouble(this.width / 2.0, this.height / 2.0));
        MyMath.rotate(p, 0.0, 0.0, this.angle);
        p.add(new PointDouble(this.midX, this.midY));
        return p;
    }

    public abstract void render(GraphicContext var1, boolean var2);

    @Override
    public Element serialize(Element parentElement) {
        XMLWriter.addAttributeInt(parentElement, "index", this.index);
        XMLWriter.addAttributeDouble(parentElement, "midX", this.midX);
        XMLWriter.addAttributeDouble(parentElement, "midY", this.midY);
        XMLWriter.addAttributeDouble(parentElement, "width", this.width);
        XMLWriter.addAttributeDouble(parentElement, "height", this.height);
        XMLWriter.addAttributeDouble(parentElement, "angle", this.angle);
        XMLWriter.addAttribute(parentElement, "editingallowed", this.isEditingAllowedInFillinModus.toString());
        this.lineStyle.serialize(parentElement);
        if (this.scripts != null) {
            for (Script script : this.scripts) {
                script.serialize(parentElement);
            }
        }
        return parentElement;
    }

    @Override
    public void deSerialize(Element element) {
        Element lineStyleElement;
        String s;
        Double d;
        Integer i = XMLReader.elementIntegerAttribute(element, "index");
        if (i != null) {
            this.index = i;
            if (nextObjectIndex <= this.index) {
                nextObjectIndex = this.index + 1;
            }
        }
        if ((d = XMLReader.elementDoubleAttribute(element, "midX")) != null) {
            this.midX = d;
        }
        if ((d = XMLReader.elementDoubleAttribute(element, "midY")) != null) {
            this.midY = d;
        }
        if ((d = XMLReader.elementDoubleAttribute(element, "width")) != null) {
            this.width = d;
        }
        if ((d = XMLReader.elementDoubleAttribute(element, "height")) != null) {
            this.height = d;
        }
        if ((d = XMLReader.elementDoubleAttribute(element, "angle")) != null) {
            this.angle = d;
        }
        if ((s = XMLReader.attribute(element, "editingallowed")) != null) {
            this.isEditingAllowedInFillinModus = EditingAllowedInFillinModus.valueOf(s);
        }
        if ((lineStyleElement = XMLReader.element(element, MyLineStyle.getXMLName())) != null) {
            this.lineStyle.deSerialize(lineStyleElement);
        }
        if (this.getPossibleEvents() != null) {
            this.scripts = Script.deserializeScripts(element);
        }
    }

    public boolean isPreviewObject() {
        return this.isPreviewObject;
    }

    public void setPreviewObject(boolean isPreviewObject) {
        this.isPreviewObject = isPreviewObject;
    }

    public EditingAllowedInFillinModus getIsEditingAllowedInFillinModus() {
        return this.isEditingAllowedInFillinModus;
    }

    public void setIsEditingAllowedInFillinModus(EditingAllowedInFillinModus isEditingAllowedInFillinModus) {
        this.isEditingAllowedInFillinModus = isEditingAllowedInFillinModus;
    }

    public int getIndex() {
        return this.index;
    }

    public MyObject() {
        this.index = nextObjectIndex++;
    }

    public ArrayList<ViewportIcon> getIcons() {
        return this.icons;
    }

    public boolean hasIcons() {
        return this.icons.size() > 0;
    }

    public boolean isDrawOnlyQuadratic() {
        return false;
    }

    public void setDirty() {
        if (this.page != null) {
            this.page.setDirty();
        }
    }

    public Rectangle2D getRealSizeRectangle() {
        return new Rectangle2D.Double(this.midX - this.width / 2.0, this.midY - this.height / 2.0, this.width, this.height);
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public ArrayList<Script> getScripts() {
        return this.scripts;
    }

    public void setScripts(ArrayList<Script> scripts) {
        this.scripts = scripts;
    }

    public ScriptableObject getScriptableObject() {
        return new ScriptableObject(this);
    }

    @Override
    public void fireEvent(Eventtype eventtype) {
        DocumentScriptingContext dscrc;
        Script script = this.getScript(eventtype);
        if (script != null && (dscrc = this.getDocument().getDocumentScriptingContext()) != null) {
            Interpreter interpreter = dscrc.getInterpreter();
            try {
                interpreter.set("objekt", this.getScriptableObject());
                interpreter.eval(script.getScript());
            }
            catch (EvalError e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Script getScript(Eventtype eventtype) {
        if (this.scripts != null) {
            for (Script script : this.scripts) {
                if (script.getEventtype() != eventtype) continue;
                return script;
            }
            return null;
        }
        return null;
    }

    @Override
    public void setScriptText(Eventtype eventtype, String text) {
        Script script = this.getScript(eventtype);
        if (!text.isEmpty()) {
            if (this.scripts == null) {
                this.scripts = new ArrayList();
            }
            if (script == null) {
                script = new Script(eventtype);
                this.scripts.add(script);
            }
            script.setScript(text);
        } else if (script != null) {
            this.scripts.remove(script);
            if (this.scripts.size() == 0) {
                this.scripts = null;
            }
        }
    }

    public PointDouble getEdgeRotated(DirectionX directionX, DirectionY directionY) {
        double x = this.midX;
        double y = this.midY;
        switch (directionX) {
            case LEFT: {
                x -= this.width / 2.0;
                break;
            }
            case RIGHT: {
                x += this.width / 2.0;
                break;
            }
        }
        switch (directionY) {
            case TOP: {
                y -= this.height / 2.0;
                break;
            }
            case BOTTOM: {
                y += this.height / 2.0;
                break;
            }
        }
        PointDouble p = new PointDouble(x, y);
        MyMath.rotate(p, this.midX, this.midY, this.angle);
        return p;
    }

    public static enum DirectionX {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum DirectionY {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum EditingAllowedInFillinModus {
        allowed,
        denied,
        indefinite,
        notKnown;

    }

    public static enum HandleDirection {
        topleft,
        topright,
        bottomleft,
        bottomright,
        top,
        bottom,
        left,
        right;

    }
}

