/*
 * Decompiled with CFR 0.152.
 */
package document.interactiveobjects;

import data.scripting.ScrCheckBox;
import data.scripting.ScriptableObject;
import document.MyDataSharingObject;
import document.MyObject;
import document.Renderable;
import document.events.Eventtype;
import document.interactiveobjects.AbstractInteractiveObject;
import document.text.MyTextField;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.graphiccontext.GraphicContext;
import gui.components.pageviewport.handles.HandleController;
import gui.components.pageviewport.paintjobs.PaintJobPaintTextField;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.math.PointDouble;
import util.math.PointInt;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class MyCheckbox
extends AbstractInteractiveObject {
    private static final Eventtype[] SCRIPTTYPES = new Eventtype[]{Eventtype.OBJECT_SETUP, Eventtype.OBJECT_LOOSE_FOCUS};
    boolean isChecked = true;

    @Override
    public boolean keyTyped(KeyEvent e, PageViewPortController controller) {
        if (e.getKeyChar() == ' ' || e.getKeyChar() == '\n') {
            this.isChecked = !this.isChecked;
            this.fireDataChangedEvent();
            e.consume();
            this.doRepainting(controller);
        }
        return false;
    }

    public void doRepainting(PageViewPortController controller) {
        PaintJobPaintTextField job = new PaintJobPaintTextField(this, controller, true, true, true);
        controller.getPageViewport().addJob(job);
        controller.doRepaint();
    }

    @Override
    public boolean keyboardpressed(KeyEvent e, PageViewPortController controller) {
        e.consume();
        return false;
    }

    @Override
    public void mouseLeftDown(PointDouble p, PointInt pControl, boolean shiftPressed, PageViewPortController controller) {
    }

    @Override
    public void mouseLeftUp(PointDouble p, boolean shiftPressed, PageViewPortController controller) {
        this.isChecked = !this.isChecked;
        this.fireDataChangedEvent();
        this.doRepainting(controller);
    }

    @Override
    public void setFocus(boolean focus, PageViewPortController controller) {
        super.setFocus(focus, controller);
        this.doRepainting(controller);
    }

    @Override
    public void mouseMoved(PointDouble p, MouseEvent e, PageViewPortController controller) {
    }

    @Override
    public void mouseRightDown(PointDouble p, boolean shiftPressed, PageViewPortController controller) {
    }

    @Override
    public void mouseRightUp(PointDouble p, PointInt pControl, boolean shiftPressed, PageViewPortController controller) {
    }

    @Override
    public void renderActiveTextfield(GraphicContext gc, boolean onlyRenderDirtyRegions, PageViewPortController controller) {
        gc.setPageCoordinates();
        Rectangle2D.Double rect = new Rectangle2D.Double(this.midX - this.width / 2.0, this.midY - this.height / 2.0, this.width, this.height);
        this.getFilling().setPaint(gc);
        if (this.hasFocus()) {
            gc.setColor(MyTextField.getActiveTextfieldColor());
        }
        gc.fill(rect);
        this.getLineStyle().setStroke(gc);
        gc.draw(rect);
        if (this.isChecked) {
            Line2D.Double line = new Line2D.Double(this.midX - this.width / 2.0, this.midY - this.height / 2.0, this.midX + this.width / 2.0, this.midY + this.height / 2.0);
            gc.draw(line);
            line = new Line2D.Double(this.midX + this.width / 2.0, this.midY - this.height / 2.0, this.midX - this.width / 2.0, this.midY + this.height / 2.0);
            gc.draw(line);
        }
    }

    @Override
    public void dataChanged() {
        if (this.getDataSource() != null) {
            this.setData(this.getDataSource().getData());
        }
    }

    @Override
    public Object getData() {
        return new Boolean(this.isChecked);
    }

    @Override
    public void setData(Object data) {
        this.isChecked = (Boolean)data;
    }

    @Override
    public void setDataSource(MyDataSharingObject dataSource) {
        if (dataSource != null) {
            this.dataSource = dataSource;
            dataSource.addDataSharer(this);
        } else if (this.getDataSource() != null) {
            this.dataSource = null;
        }
    }

    @Override
    public MyObject getCopy() {
        MyCheckbox copy = new MyCheckbox();
        super.copyTo(copy);
        copy.isChecked = this.isChecked;
        return copy;
    }

    @Override
    public void getHandles(ArrayList<HandleController> handleList, PageViewport pageViewPort) {
        this.getDiagonalStretchingHandles(handleList, pageViewPort, true);
    }

    @Override
    protected void makeShape() {
    }

    @Override
    public void render(GraphicContext gc, boolean isPreview) {
        gc.setPageCoordinates();
        Rectangle2D.Double rect = new Rectangle2D.Double(this.midX - this.width / 2.0, this.midY - this.height / 2.0, this.width, this.height);
        this.getFilling().setPaint(gc);
        gc.fill(rect);
        this.getLineStyle().setStroke(gc);
        gc.draw(rect);
        if (this.isChecked) {
            Line2D.Double line = new Line2D.Double(this.midX - this.width / 2.0, this.midY - this.height / 2.0, this.midX + this.width / 2.0, this.midY + this.height / 2.0);
            gc.draw(line);
            line = new Line2D.Double(this.midX + this.width / 2.0, this.midY - this.height / 2.0, this.midX - this.width / 2.0, this.midY + this.height / 2.0);
            gc.draw(line);
        }
    }

    @Override
    public Renderable.ObjectType getType() {
        return Renderable.ObjectType.checkbox;
    }

    @Override
    public boolean isInside(PointDouble page) {
        return Math.abs(page.x - this.midX) <= this.width / 2.0 && Math.abs(page.y - this.midY) <= this.height / 2.0;
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(MyCheckbox.getXMLName(), parentElement);
        super.serialize(element);
        this.serializeSchuelerZeugnisData(element);
        return element;
    }

    public static String getXMLName() {
        return "checkbox";
    }

    @Override
    public void deSerialize(Element element) {
        super.deSerialize(element);
        this.deserializeSchuelerZeugnisData(element);
    }

    @Override
    public Cursor getTextCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    public boolean isDrawOnlyQuadratic() {
        return true;
    }

    @Override
    protected void deserializeSchuelerZeugnisData(Element element) {
        Boolean checked = XMLReader.elementBooleanAttribute(element, "ischecked");
        if (checked != null) {
            this.isChecked = checked;
        }
    }

    @Override
    public boolean hasSchuelerZeugnisData() {
        return this.getIsEditingAllowedInFillinModus() == MyObject.EditingAllowedInFillinModus.allowed && this.getDataSource() == null;
    }

    @Override
    protected void serializeSchuelerZeugnisData(Element element) {
        XMLWriter.addAttributeBoolean(element, "ischecked", this.isChecked);
    }

    @Override
    public Eventtype[] getPossibleEvents() {
        return SCRIPTTYPES;
    }

    @Override
    public ScriptableObject getScriptableObject() {
        return new ScrCheckBox(this);
    }
}

