/*
 * Decompiled with CFR 0.152.
 */
package document.marks;

import commands.changemarkfield.SetMarkValueCommand;
import document.marks.AbstractMarkModel;
import document.marks.IntegerMark;
import document.marks.Mark;
import document.marks.MyMarkField;

public class MarkModelSehrgutToUngenuegend
extends AbstractMarkModel {
    private IntegerMark mark = new IntegerMark();
    private char[] numberChars = new char[]{'1', '2', '3', '4', '5', '6'};
    private char[] upperCaseDigitChars = new char[]{'!', '\"', '\u00a7', '$', '%', '&'};
    private char[] alphabeticChars = new char[]{'s', 'g', 'b', 'a', 'm', 'u'};
    private char[] upperCaseAlphabeticChars = new char[]{'S', 'G', 'B', 'A', 'M', 'U'};
    private String[] strings = new String[]{"---", "sehr gut", "gut", "befriedigend", "ausreichend", "mangelhaft", "ungen\u00fcgend"};

    public MarkModelSehrgutToUngenuegend(MyMarkField markField) {
        super(markField);
    }

    @Override
    public int getCursorPosition() {
        return 0;
    }

    @Override
    public int getInteger() {
        return this.mark.getIntValue();
    }

    @Override
    public String getText() {
        if (this.mark != null) {
            return this.strings[this.mark.getIntValue()];
        }
        return this.strings[0];
    }

    @Override
    public boolean hasCursor() {
        return false;
    }

    @Override
    public void resetInputState() {
    }

    @Override
    public boolean typeCharacter(char c) {
        int newMark = -1;
        int i = 0;
        while (i < this.numberChars.length) {
            if (c == this.numberChars[i]) {
                newMark = i + 1;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.upperCaseDigitChars.length) {
            if (c == this.upperCaseDigitChars[i]) {
                newMark = i + 1;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.alphabeticChars.length) {
            if (c == this.alphabeticChars[i]) {
                newMark = i + 1;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.upperCaseAlphabeticChars.length) {
            if (c == this.upperCaseAlphabeticChars[i]) {
                newMark = i + 1;
                break;
            }
            ++i;
        }
        char code = c;
        if (code == '\b' || code == '\u007f' || c == '-') {
            newMark = 0;
        }
        if (newMark != -1) {
            SetMarkValueCommand command = new SetMarkValueCommand(new Integer(newMark), this, this.markfield.getCommandManager());
            return true;
        }
        return false;
    }

    @Override
    public String getTypeString() {
        return "sehr gut ... ungen\u00fcgend";
    }

    @Override
    public AbstractMarkModel getCopy(MyMarkField markfield) {
        MarkModelSehrgutToUngenuegend model = new MarkModelSehrgutToUngenuegend(markfield);
        model.mark = new IntegerMark();
        model.mark.setIntValue(this.mark.getIntValue());
        return model;
    }

    @Override
    public Mark getMarkObject() {
        return this.mark;
    }

    @Override
    public Object getMarkValue() {
        return this.mark.getValue();
    }

    @Override
    public void setMarkObject(Mark mark) {
        this.mark = (IntegerMark)mark;
    }

    @Override
    public void setMarkValue(Object value) {
        this.mark.setValue(value);
    }

    @Override
    public String getXMLName() {
        return "sehrgut-ungenuegend";
    }

    @Override
    public void setMarkFromString(String markAsString) {
        int z = Integer.parseInt(markAsString);
        if (z >= 0 && z <= 6) {
            this.mark.setIntValue(z);
        }
    }

    @Override
    public AbstractMarkModel.MarkRange getType() {
        return AbstractMarkModel.MarkRange.mr1to6;
    }
}

