/*
 * Decompiled with CFR 0.152.
 */
package document.text;

import gui.components.pageviewport.graphiccontext.LineMetricsCm;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import util.fontmanager.FontManager;

public class DeviceIndependentFontMetrics {
    protected String fontName;
    protected FontRenderContext frc;
    protected Font font300Dpi;
    private float whiteSpaceWidth;
    private float hyphenWidth;
    private Font font;
    protected static float factorCmProPixel300dpi = 0.008466667f;

    public DeviceIndependentFontMetrics() {
        AffineTransform tx = new AffineTransform();
        tx.setToIdentity();
        this.frc = new FontRenderContext(tx, true, true);
    }

    public Rectangle2D getStringBounds(String str, int beginIndex, int limit) {
        Rectangle2D.Double cmRect;
        if ((str = str.substring(beginIndex, limit)).length() > 0) {
            TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
            Rectangle2D rect = layout.getBounds();
            cmRect = new Rectangle2D.Double(rect.getX() * (double)factorCmProPixel300dpi, rect.getY() * (double)factorCmProPixel300dpi, rect.getWidth() * (double)factorCmProPixel300dpi, rect.getHeight() * (double)factorCmProPixel300dpi);
        } else {
            cmRect = new Rectangle2D.Double();
        }
        return cmRect;
    }

    public float getStringAdvance(String str, int beginIndex, int limit) {
        if ((str = str.substring(beginIndex, limit)).length() > 0) {
            TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
            return layout.getAdvance() * factorCmProPixel300dpi;
        }
        return 0.0f;
    }

    public float getStringAdvance(String str) {
        if (str.length() > 0) {
            TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
            return layout.getAdvance() * factorCmProPixel300dpi;
        }
        return 0.0f;
    }

    public Rectangle2D getStringBounds(String str) {
        TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
        Rectangle2D rect = layout.getBounds();
        Rectangle2D.Double cmRect = new Rectangle2D.Double(rect.getX() * (double)factorCmProPixel300dpi, rect.getY() * (double)factorCmProPixel300dpi, rect.getWidth() * (double)factorCmProPixel300dpi, rect.getHeight() * (double)factorCmProPixel300dpi);
        return cmRect;
    }

    public float getCursorSlope() {
        return this.font300Dpi.getItalicAngle();
    }

    public int getCursorPos(String str, float x, float y) {
        if (str.length() <= 0) {
            return 0;
        }
        int pos = 0;
        int i = 0;
        while (i < str.length()) {
            float left = i == 0 ? 0.0f : (float)this.getStringBounds(str.substring(0, i)).getWidth();
            float right = (float)this.getStringBounds(str.substring(0, i + 1)).getWidth();
            if (left <= x && x <= right) {
                if (x - left < right - x) {
                    pos = i;
                    break;
                }
                pos = i + 1;
                break;
            }
            ++i;
        }
        return pos;
    }

    public int getCharacterAtPos(String str, float x, float y) {
        TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
        TextHitInfo thi = layout.hitTestChar(x /= factorCmProPixel300dpi, y);
        int pos = thi.getCharIndex();
        if (pos < 0) {
            pos = 0;
        }
        if (pos > str.length() - 1) {
            pos = str.length() - 1;
        }
        return pos;
    }

    public LineMetricsCm getLineMetrics(String str) {
        LineMetrics lm = this.font300Dpi.getLineMetrics(str, this.frc);
        return new LineMetricsCm(lm);
    }

    public float getAscent(String str) {
        TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
        return layout.getAscent() * factorCmProPixel300dpi;
    }

    public float getDescent(String str) {
        TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
        return layout.getDescent() * factorCmProPixel300dpi;
    }

    public float getLeading(String str) {
        TextLayout layout = new TextLayout(str, this.font300Dpi, this.frc);
        return layout.getLeading() * factorCmProPixel300dpi;
    }

    public TextLayout getTextLayout(String str) {
        return new TextLayout(str, this.font300Dpi, this.frc);
    }

    public static float getCmFactor() {
        return factorCmProPixel300dpi;
    }

    public void setFont(Font font) {
        this.font = font;
        AffineTransform at = new AffineTransform();
        at.setToIdentity();
        double factor = 4.166666666666666;
        at.scale(factor, factor);
        int style = font.getStyle();
        this.font300Dpi = (style & 2) != 0 ? FontManager.getInstance().getFont(this.fontName, style -= 2, font.getSize()).deriveFont(at) : font.deriveFont(at);
        this.whiteSpaceWidth = (float)this.getStringBounds("A B").getWidth() - (float)this.getStringBounds("AB").getWidth();
        this.hyphenWidth = (float)this.getStringBounds("-").getWidth();
    }

    public void setFont(String fontName, int size, boolean isBold, boolean isItalic) {
        int style = 0;
        if (isBold || isItalic) {
            if (isBold) {
                style |= 1;
            }
            if (isItalic) {
                style |= 2;
            }
        }
        this.font = FontManager.getInstance().getFont(fontName, style, size);
        this.setFont(this.font);
    }

    public float getWhiteSpaceWidth() {
        return this.whiteSpaceWidth;
    }

    public float getHyphenWidth() {
        return this.hyphenWidth;
    }

    public Font getFont() {
        return this.font;
    }
}

