/*
 * Decompiled with CFR 0.152.
 */
package document.text;

import document.text.AttributedTextLayouter;
import document.text.ChunkPosition;
import document.text.HorizontalAlignment;
import document.text.TextFieldView;
import document.text.chunks.Chunk;
import document.text.chunks.TextChunk;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import util.logging.Log;
import util.math.MyMath;
import util.math.PointFloat;

public class Line {
    private long timeStamp = -1L;
    private long sumOfTimeStamps = 0L;
    private ChunkPosition startChunkPosition;
    private int startChunkIndex;
    private ChunkPosition endChunkPosition;
    private int numberOfChunks = 0;
    private float[] x;
    private float[] y;
    private AttributedTextLayouter attributedTextLayouter;
    private HorizontalAlignment alignment = HorizontalAlignment.left;
    private float descent;
    private float ascent;
    private float leading;
    private float baseline;
    private int numberOfWhiteSpaces = 0;
    private float justifiedWhiteSpaceWidth;

    public Line(AttributedTextLayouter attributedTextLayouter) {
        this.attributedTextLayouter = attributedTextLayouter;
    }

    private void testAscentDescentLeading(ChunkPosition cp) {
        if (cp.getChunk().getAscent() > this.ascent) {
            this.ascent = cp.getChunk().getAscent();
        }
        if (cp.getChunk().getDescent() > this.descent) {
            this.descent = cp.getChunk().getDescent();
        }
        if (cp.getChunk().getLeading() > this.leading) {
            this.leading = cp.getChunk().getLeading();
        }
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public void setChunkPositions(float nettoLineWidth, boolean isFirstLineInParagraph, float topOfLine) {
        this.x = new float[this.numberOfChunks];
        this.y = new float[this.numberOfChunks];
        float startX = 0.0f;
        float whiteSpaceWidth = 0.0f;
        ChunkPosition cp = this.startChunkPosition.getCopy();
        int cpIndex = this.startChunkIndex;
        int chunkNumber = 0;
        switch (this.alignment) {
            case left: {
                startX = 0.0f;
                break;
            }
            case right: {
                startX = this.attributedTextLayouter.getWidth() - nettoLineWidth;
                break;
            }
            case center: {
                startX = this.attributedTextLayouter.getWidth() / 2.0f - nettoLineWidth / 2.0f;
                break;
            }
            case justified: {
                whiteSpaceWidth = this.justifiedWhiteSpaceWidth;
                startX = 0.0f;
                break;
            }
        }
        boolean done = false;
        float x1 = startX;
        this.baseline = topOfLine + this.ascent;
        if (!isFirstLineInParagraph && cp.getChunk().isWhiteSpace()) {
            if (++cpIndex < this.attributedTextLayouter.getChunks().size()) {
                cp.setChunk(this.attributedTextLayouter.getChunks().get(cpIndex));
                cp.setPosition(0);
            } else {
                cp = null;
            }
            this.x[chunkNumber] = -1000.0f;
            this.y[chunkNumber] = this.baseline;
            ++chunkNumber;
        }
        while (cp != null && !done && chunkNumber < this.numberOfChunks) {
            this.x[chunkNumber] = x1;
            this.y[chunkNumber] = this.baseline;
            if (cp.getChunk() != this.endChunkPosition.getChunk() || cp.getPosition() < this.endChunkPosition.getPosition()) {
                if (cp.getChunk().isWhiteSpace()) {
                    x1 = this.alignment == HorizontalAlignment.justified ? (x1 += whiteSpaceWidth * (float)cp.getChunk().getLength()) : (x1 += cp.getChunk().getWidth());
                } else {
                    if (cp.getChunk().isTextChunk()) {
                        ((TextChunk)cp.getChunk()).setWhiteSpaceWidth(this.justifiedWhiteSpaceWidth);
                    }
                    if (cp.getChunk() != this.startChunkPosition.getChunk() && cp.getChunk() != this.endChunkPosition.getChunk() || cp.getChunk().isLineBreak()) {
                        x1 += cp.getChunk().getAdvance();
                    } else {
                        TextChunk tc = (TextChunk)cp.getChunk();
                        int startPos = 0;
                        int endPos = tc.getText().length();
                        if (tc == this.startChunkPosition.getChunk()) {
                            startPos = this.startChunkPosition.getPosition();
                        }
                        if (tc == this.endChunkPosition.getChunk()) {
                            endPos = this.endChunkPosition.getPosition();
                        }
                        x1 += ((TextChunk)cp.getChunk()).getAdvance(startPos, endPos);
                    }
                }
                if (++cpIndex < this.attributedTextLayouter.getChunks().size()) {
                    cp.setChunk(this.attributedTextLayouter.getChunks().get(cpIndex));
                    cp.setPosition(0);
                } else {
                    cp = null;
                }
            } else {
                done = true;
            }
            ++chunkNumber;
        }
    }

    public Line getPreviousLine() {
        int index = this.attributedTextLayouter.getLines().indexOf(this);
        if (index > 0) {
            return this.attributedTextLayouter.getLines().get(index - 1);
        }
        return null;
    }

    public Line getNextLine() {
        int index = this.attributedTextLayouter.getLines().indexOf(this);
        if (index < this.attributedTextLayouter.getLines().size() - 1) {
            return this.attributedTextLayouter.getLines().get(index + 1);
        }
        return null;
    }

    public float getJustifiedWhiteSpaceWidth() {
        return this.justifiedWhiteSpaceWidth;
    }

    public float getBaseline() {
        return this.baseline;
    }

    public void setBaseline(float baseline) {
        this.baseline = baseline;
    }

    public float getDescent() {
        return this.descent;
    }

    public ChunkPosition layout(ChunkPosition startChunkPosition, boolean isFirstLineInParagraph, float topOfLine, HorizontalAlignment paragraphAlignment) {
        float nettoLineWidth = 0.0f;
        float whiteSpaceWidth = 0.0f;
        this.ascent = 0.0f;
        this.descent = 0.0f;
        boolean done = false;
        this.startChunkPosition = startChunkPosition;
        this.endChunkPosition = startChunkPosition;
        ChunkPosition cp = startChunkPosition.getCopy();
        this.numberOfWhiteSpaces = 0;
        this.numberOfChunks = 0;
        if (!isFirstLineInParagraph && cp.getChunk().isWhiteSpace()) {
            cp = cp.getNextChunkStart();
            ++this.numberOfChunks;
        }
        boolean lastChunkIsWhiteSpace = false;
        float lastWhiteSpaceWidth = 0.0f;
        int lastWhiteSpaceLength = 0;
        while (!done && cp.getChunk() != null) {
            if (cp.getChunk().isWhiteSpace()) {
                float chunkWidth = cp.getChunk().getWidth();
                if (!(nettoLineWidth + chunkWidth > this.attributedTextLayouter.getWidth())) {
                    this.numberOfWhiteSpaces += cp.getChunk().getLength();
                    nettoLineWidth += chunkWidth;
                    whiteSpaceWidth += chunkWidth;
                    lastChunkIsWhiteSpace = true;
                    lastWhiteSpaceWidth = chunkWidth;
                    lastWhiteSpaceLength = cp.getChunk().getLength();
                }
                this.testAscentDescentLeading(cp);
                cp = cp.getNextChunkStart();
                ++this.numberOfChunks;
                continue;
            }
            if (cp.getChunk().isTextChunk()) {
                TextChunk chunk = (TextChunk)cp.getChunk();
                chunk.setWhiteSpaceWidthToMinimum();
                int endPosition = chunk.getMaximumEndPosition(cp.getPosition(), this.attributedTextLayouter.getWidth() - nettoLineWidth);
                if (cp.getPosition() == endPosition || endPosition == 0) {
                    if (Math.abs(nettoLineWidth) < 1.0E-6f) {
                        nettoLineWidth += chunk.getAdvance();
                        this.testAscentDescentLeading(cp);
                        cp = cp.getNextChunkStart();
                        ++this.numberOfChunks;
                        lastChunkIsWhiteSpace = false;
                    }
                    done = true;
                    continue;
                }
                if (endPosition == chunk.getLength()) {
                    nettoLineWidth += chunk.getAdvance(cp.getPosition(), endPosition);
                    this.testAscentDescentLeading(cp);
                    cp = cp.getNextChunkStart();
                    ++this.numberOfChunks;
                    lastChunkIsWhiteSpace = false;
                    continue;
                }
                nettoLineWidth += chunk.getTextWidthWithHyphen(cp.getPosition(), endPosition);
                cp.setPosition(endPosition);
                done = true;
                ++this.numberOfChunks;
                this.testAscentDescentLeading(cp);
                lastChunkIsWhiteSpace = false;
                continue;
            }
            this.testAscentDescentLeading(cp);
            ++this.numberOfChunks;
            done = true;
            cp.setPosition(1);
        }
        if (lastChunkIsWhiteSpace) {
            nettoLineWidth -= lastWhiteSpaceWidth;
            whiteSpaceWidth -= lastWhiteSpaceWidth;
            this.numberOfWhiteSpaces -= lastWhiteSpaceLength;
        }
        this.alignment = cp.getChunk() != null && cp.getChunk().isLineBreak() && paragraphAlignment == HorizontalAlignment.justified ? HorizontalAlignment.left : paragraphAlignment;
        this.justifiedWhiteSpaceWidth = paragraphAlignment == HorizontalAlignment.justified && this.numberOfWhiteSpaces > 0 ? (this.attributedTextLayouter.getWidth() - (nettoLineWidth - whiteSpaceWidth)) / (float)this.numberOfWhiteSpaces : -1.0f;
        this.endChunkPosition = cp.getCopy();
        if (this.endChunkPosition.getPosition() == 0) {
            this.endChunkPosition.normalize0ToStringEnd();
        }
        this.setChunkPositions(nettoLineWidth, isFirstLineInParagraph, topOfLine);
        return cp;
    }

    public ChunkPosition getHitPosition(float xp, float yp) {
        Chunk chunk = this.endChunkPosition.getChunk();
        ArrayList<Chunk> chunks = this.attributedTextLayouter.getChunks();
        int i = 0;
        i = 0;
        while (i < this.x.length - 1) {
            if (xp < this.x[i + 1]) {
                chunk = chunks.get(this.startChunkIndex + i);
                break;
            }
            ++i;
        }
        if (chunk == this.startChunkPosition.getChunk()) {
            return chunk.getHitPosition(xp, yp, this, this.x[i], this.baseline, this.startChunkPosition.getPosition());
        }
        ChunkPosition cp = chunk.getHitPosition(xp, yp, this, this.x[i], this.baseline, 0);
        if (cp.getChunk() == this.endChunkPosition.getChunk() && cp.getPosition() > this.endChunkPosition.getPosition()) {
            cp.setPosition(this.endChunkPosition.getPosition());
        }
        return cp;
    }

    public float getAscent() {
        return this.ascent;
    }

    public ChunkPosition getStartChunkPosition() {
        return this.startChunkPosition;
    }

    public ChunkPosition getEndChunkPosition() {
        return this.endChunkPosition;
    }

    public PointFloat getPosition(ChunkPosition chunkPosition) {
        if (chunkPosition.getChunk() == this.endChunkPosition.getChunk() && chunkPosition.getPosition() > this.endChunkPosition.getPosition()) {
            Line line = this.getNextLine();
            if (line != null) {
                return line.getPosition(chunkPosition);
            }
            Log.log(3, "Line.getPosition: no next Line!");
            return null;
        }
        int index = chunkPosition.getChunk().getIndex() - this.startChunkPosition.getChunk().getIndex();
        if (index < 0) {
            return this.getPreviousLine().getPosition(chunkPosition);
        }
        if (index > this.x.length - 1) {
            if (this.getNextLine() != null) {
                return this.getNextLine().getPosition(chunkPosition);
            }
            return new PointFloat(this.x[this.x.length - 1], this.y[this.x.length - 1]);
        }
        float xp = this.x[index];
        float yp = this.y[index];
        int positionInChunk = chunkPosition.getPosition();
        if (index == this.x.length - 1 && chunkPosition.getChunk().isWhiteSpace() && chunkPosition.getChunk() != this.startChunkPosition.getChunk()) {
            positionInChunk = 0;
        }
        PointFloat pos = chunkPosition.getChunk().getPosition(xp, yp, positionInChunk, this);
        if (chunkPosition.getChunk() == this.startChunkPosition.getChunk() && chunkPosition.getChunk().isTextChunk()) {
            pos.x -= ((TextChunk)chunkPosition.getChunk()).getAdvance(0, this.startChunkPosition.getPosition());
        }
        return pos;
    }

    public void renderLine(TextFieldView tv, Rectangle2D boundsRect) {
        ArrayList<Chunk> chunks = this.attributedTextLayouter.getChunks();
        boolean underlinePending = false;
        float underlineXfrom = 0.0f;
        float underlineXto = 0.0f;
        float underlineThickness = 0.0f;
        float underlineOffset = 0.0f;
        float ymin = this.baseline - this.ascent - this.leading;
        float ymax = this.baseline + this.descent + this.leading;
        if (boundsRect == null || !((double)ymax <= boundsRect.getY()) && !((double)ymin >= boundsRect.getY() + boundsRect.getHeight())) {
            int end;
            int start;
            Chunk chunk = this.startChunkPosition.getChunk();
            if (chunk.isTextChunk() && chunk != this.endChunkPosition.getChunk()) {
                TextChunk tc = (TextChunk)chunk;
                tv.setTextStyle(chunk.getTextStyle());
                start = this.startChunkPosition.getPosition();
                end = tc.getLength();
                tv.renderText(this.x[0], this.y[0], tc, start, end);
                if (tc.getTextStyle().isUnderlined()) {
                    underlineThickness = tc.getTextStyle().getUnderlineThickness();
                    underlineOffset = tc.getTextStyle().getUnderlineOffset();
                    underlineXfrom = this.x[0];
                    underlineXto = this.x[0] + tc.getAdvance();
                    underlinePending = true;
                }
                tc.hasManualHyphenationPositions();
            }
            int i = 1;
            while (i < this.numberOfChunks - 1) {
                chunk = chunks.get(this.startChunkIndex + i);
                if (chunk.isTextChunk()) {
                    tv.setTextStyle(chunk.getTextStyle());
                    tv.renderText(this.x[i], this.y[i], (TextChunk)chunk, 0, chunk.getLength());
                }
                if (chunk.getTextStyle().isUnderlined()) {
                    if (underlinePending) {
                        underlineThickness = MyMath.max(underlineThickness, chunk.getTextStyle().getUnderlineThickness());
                        underlineOffset = MyMath.max(underlineOffset, chunk.getTextStyle().getUnderlineOffset());
                    } else {
                        underlineThickness = chunk.getTextStyle().getUnderlineThickness();
                        underlineOffset = chunk.getTextStyle().getUnderlineOffset();
                        underlineXfrom = this.x[i];
                        underlinePending = true;
                    }
                    underlineXto = this.x[i] + chunk.getAdvance();
                } else if (underlinePending) {
                    this.doUnderline(tv, underlineXfrom, underlineXto, this.y[0] + underlineOffset, underlineThickness);
                    underlinePending = false;
                }
                ++i;
            }
            chunk = this.endChunkPosition.getChunk();
            if (chunk.isTextChunk()) {
                tv.setTextStyle(chunk.getTextStyle());
                TextChunk tc = (TextChunk)chunk;
                start = 0;
                end = tc.getLength();
                if (chunk == this.startChunkPosition.getChunk()) {
                    start = this.startChunkPosition.getPosition();
                }
                if (this.endChunkPosition.getPosition() < end) {
                    end = this.endChunkPosition.getPosition();
                }
                tv.renderText(this.x[this.x.length - 1], this.y[this.x.length - 1], tc, start, end);
                if (chunk.isTextChunk() && (tc = (TextChunk)chunk).getTextStyle().isUnderlined()) {
                    if (underlinePending) {
                        underlineThickness = MyMath.max(underlineThickness, tc.getTextStyle().getUnderlineThickness());
                        underlineOffset = MyMath.max(underlineOffset, tc.getTextStyle().getUnderlineOffset());
                    } else {
                        underlineThickness = tc.getTextStyle().getUnderlineThickness();
                        underlineOffset = tc.getTextStyle().getUnderlineOffset();
                        underlineXfrom = this.x[this.x.length - 1];
                        underlinePending = true;
                    }
                    underlineXto = this.x[this.x.length - 1] + tc.getAdvance(start, end);
                }
            }
            if (underlinePending) {
                this.doUnderline(tv, underlineXfrom, underlineXto, this.y[0] + underlineOffset, underlineThickness);
                underlinePending = false;
            }
        }
    }

    public void doUnderline(TextFieldView tv, float underlineXfrom, float underlineXto, float underlineY, float width) {
        tv.underline(underlineXfrom, underlineXto, underlineY, width);
    }

    public void doYShifting(float dy) {
        this.baseline += dy;
        int i = 0;
        while (i < this.y.length) {
            int n = i++;
            this.y[n] = this.y[n] + dy;
        }
    }

    public int getNumberOfChunks() {
        return this.numberOfChunks;
    }

    public long getSumOfTimeStamps() {
        return this.sumOfTimeStamps;
    }

    public void setSumOfTimeStamps(long sumOfTimeStamps) {
        this.sumOfTimeStamps = sumOfTimeStamps;
    }

    public float getTop() {
        return this.baseline - this.ascent;
    }

    public float getBottom() {
        return this.baseline + this.descent + this.leading;
    }

    public float getLeading() {
        return this.leading;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public int getStartChunkIndex() {
        return this.startChunkIndex;
    }

    public void setStartChunkIndex(int startChunkIndex) {
        this.startChunkIndex = startChunkIndex;
    }

    public void calculateSumOfTimeStamps() {
        ArrayList<Chunk> chunks = this.attributedTextLayouter.getChunks();
        this.sumOfTimeStamps = 0L;
        if (this.startChunkIndex + this.numberOfChunks > chunks.size()) {
            this.numberOfChunks = chunks.size() - this.startChunkIndex;
        }
        int i = 0;
        while (i < this.numberOfChunks) {
            this.sumOfTimeStamps += chunks.get(this.startChunkIndex + i).getTimeStamp();
            ++i;
        }
    }
}

