/*
 * Decompiled with CFR 0.152.
 */
package document.text.chunks;

import document.text.AttributedText;
import document.text.ChunkPosition;
import document.text.DeviceIndependentFontMetrics;
import document.text.HorizontalAlignment;
import document.text.Line;
import document.text.chunks.Chunk;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.logging.Log;
import util.math.PointFloat;
import util.xml.XMLWriter;

public class LineBreak
extends Chunk {
    private long timeStampSum = -1L;
    private HorizontalAlignment alignment = HorizontalAlignment.justified;

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
        this.setDirty();
    }

    public LineBreak(AttributedText attributedText) {
        super(attributedText);
        this.type = Chunk.ChunkType.linebreak;
    }

    @Override
    public void calculateMetrics() {
        TextLayout tl = this.textStyle.getTextLayout("Mg");
        this.ascent = tl.getAscent() * DeviceIndependentFontMetrics.getCmFactor();
        this.descent = tl.getDescent() * DeviceIndependentFontMetrics.getCmFactor();
        this.leading = tl.getLeading() * DeviceIndependentFontMetrics.getCmFactor();
        this.advance = tl.getAdvance() * DeviceIndependentFontMetrics.getCmFactor();
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public void split(int position) {
        this.setDirty();
    }

    @Override
    public void merge(ArrayList<Chunk> chunks) {
        this.setDirty();
    }

    @Override
    public Chunk getCopyOfPart(int fromPosition, int toPosition) {
        return this.getCopy();
    }

    @Override
    public Chunk getCopy() {
        LineBreak copy = new LineBreak(this.attributedText);
        copy.setTextStyle(this.textStyle);
        copy.calculateMetrics();
        copy.setAlignment(this.alignment);
        return copy;
    }

    @Override
    public ChunkPosition getHitPosition(float x, float y, Line line, float chunkX, float chunkBaseline, int startPos) {
        return new ChunkPosition(this, 0);
    }

    @Override
    public PointFloat getPosition(float xp, float yp, int position, Line line) {
        if (position != 0) {
            Log.log(4, "LineBreak.getPosition: position should be 0.");
        }
        return new PointFloat(xp, yp);
    }

    @Override
    public Chunk getSubChunkLeft(int toPosition) {
        this.setDirty();
        if (toPosition > 0) {
            return this.getCopy();
        }
        return null;
    }

    @Override
    public Chunk getSubChunkMid(int fromPosition, int toPosition) {
        this.setDirty();
        if (fromPosition <= 0 && toPosition >= 1) {
            return this.getCopy();
        }
        return null;
    }

    @Override
    public Chunk getSubChunkRight(int fromPosition) {
        this.setDirty();
        if (fromPosition <= 0) {
            return this.getCopy();
        }
        return null;
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + this.getIndex() + " LB: " + super.toString();
        return s;
    }

    public String getAlignmentAsString() {
        String s;
        switch (this.alignment) {
            case left: {
                s = "left";
                break;
            }
            case right: {
                s = "right";
                break;
            }
            case center: {
                s = "center";
                break;
            }
            case justified: {
                s = "justified";
                break;
            }
            default: {
                s = "";
            }
        }
        return s;
    }

    public void setAlignmentFromString(String s) {
        if (s.compareTo("left") == 0) {
            this.setAlignment(HorizontalAlignment.left);
        } else if (s.compareTo("right") == 0) {
            this.setAlignment(HorizontalAlignment.right);
        } else if (s.compareTo("center") == 0) {
            this.setAlignment(HorizontalAlignment.center);
        } else if (s.compareTo("justified") == 0) {
            this.setAlignment(HorizontalAlignment.justified);
        }
    }

    @Override
    public void deSerialize(Element element) {
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement("br", parentElement);
        XMLWriter.addAttribute(element, "alignment", this.getAlignmentAsString());
        return element;
    }

    @Override
    public String getAsString() {
        return "\n";
    }

    public long getTimeStampSum() {
        return this.timeStampSum;
    }

    public void setTimeStampSum(long timeStampSum) {
        this.timeStampSum = timeStampSum;
    }
}

