/*
 * Decompiled with CFR 0.152.
 */
package document.text.chunks;

import document.text.AttributedText;
import document.text.ChunkPosition;
import document.text.DeviceIndependentFontMetrics;
import document.text.Line;
import document.text.chunks.Chunk;
import document.text.chunks.SpellingState;
import document.text.hyphenation.Hyphenation;
import document.text.menutext.TextMenu;
import document.text.spellcheck.SpellTask;
import document.text.spellcheck.SpellTasks;
import document.text.spellcheck.Spellchecker;
import init.Settings;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.Collections;
import org.w3c.dom.Element;
import util.math.MyMath;
import util.math.PointFloat;

public class TextChunk
extends Chunk {
    private String term = "";
    private String textInEditMode = "";
    private TextMenu textMenu = null;
    private int textMenuFrom;
    private int textMenuTo;
    private float currentWidth = 0.0f;
    private String text;
    private SpellingState spellingState = SpellingState.notChecked;
    private float whiteSpaceWidth;
    private ArrayList<Integer> manualHyphenationPositions = new ArrayList();
    private byte[] automaticHyphenationPositions;

    public TextChunk(String text, AttributedText attributedText) {
        super(attributedText);
        this.type = Chunk.ChunkType.text;
        this.setText(text);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.calculateMetrics();
        this.addSpellTask();
        this.automaticHyphenationPositions = null;
    }

    @Override
    public void calculateMetrics() {
        this.width = (float)this.textStyle.getStringBounds(this.text).getWidth();
        TextLayout tl = this.textStyle.getTextLayout(this.text);
        this.ascent = tl.getAscent() * DeviceIndependentFontMetrics.getCmFactor();
        this.descent = tl.getDescent() * DeviceIndependentFontMetrics.getCmFactor();
        this.leading = tl.getLeading() * DeviceIndependentFontMetrics.getCmFactor();
        this.advance = tl.getAdvance() * DeviceIndependentFontMetrics.getCmFactor();
        this.currentWidth = (float)this.textStyle.getStringBounds(this.text, 0, this.text.length()).getWidth();
        this.setDirty();
    }

    public void addManualHyphenationPosition(int position) {
        boolean isInList = false;
        int i = 0;
        while (i < this.manualHyphenationPositions.size()) {
            if (this.manualHyphenationPositions.get(i) == position) {
                isInList = true;
                this.manualHyphenationPositions.remove(i);
                break;
            }
            ++i;
        }
        if (!isInList) {
            this.manualHyphenationPositions.add(position);
            Collections.sort(this.manualHyphenationPositions);
        }
        this.setDirty();
    }

    public void removeManualHyphenationPosition(int position) {
        int i = 0;
        while (i < this.manualHyphenationPositions.size()) {
            if (this.manualHyphenationPositions.get(i) == position) {
                this.manualHyphenationPositions.remove(i);
                this.setDirty();
                continue;
            }
            ++i;
        }
    }

    public float getTextWidth(int startPosition, int endPosition) {
        if (startPosition == 0 && endPosition == this.text.length()) {
            return this.currentWidth;
        }
        return this.textStyle.getStringWidth(this.text, startPosition, endPosition);
    }

    public int getMaximumEndPosition(int startPosition, float maximumWidth) {
        int endPosition = this.text.length();
        if (this.getTextWidth(startPosition, this.text.length()) > maximumWidth) {
            if (this.automaticHyphenationPositions == null) {
                this.automaticHyphenationPositions = Hyphenation.getInstance().getHyphenationArray(this.text);
            }
            int manualHyphenPosIndex = this.manualHyphenationPositions.size() - 1;
            int automaticHyphenPosIndex = this.automaticHyphenationPositions.length - 1;
            boolean done = false;
            do {
                int automaticHyphenPos;
                int manualHyphenPos;
                if ((endPosition = MyMath.max(manualHyphenPos = manualHyphenPosIndex >= 0 ? this.manualHyphenationPositions.get(manualHyphenPosIndex) : -1, automaticHyphenPos = automaticHyphenPosIndex >= 0 && this.manualHyphenationPositions.size() <= 0 ? this.automaticHyphenationPositions[automaticHyphenPosIndex] : -1)) <= startPosition) {
                    done = true;
                    endPosition = startPosition;
                    continue;
                }
                if (this.getTextWidth(startPosition, endPosition) + this.textStyle.getHyphenWidth() <= maximumWidth) {
                    done = true;
                    continue;
                }
                if (manualHyphenPos == automaticHyphenPos) {
                    --manualHyphenPosIndex;
                    --automaticHyphenPosIndex;
                    continue;
                }
                if (manualHyphenPos > automaticHyphenPos) {
                    --manualHyphenPosIndex;
                    continue;
                }
                --automaticHyphenPosIndex;
            } while (!done);
        }
        return endPosition;
    }

    @Override
    public int getLength() {
        return this.text.length();
    }

    @Override
    public void split(int position) {
        if (position != 0 && position != this.getLength()) {
            String right = this.text.substring(position);
            this.setText(this.text.substring(0, position));
            TextChunk rightChunk = new TextChunk(right, this.attributedText);
            rightChunk.setTextStyle(this.textStyle);
            int i = 0;
            while (i < this.manualHyphenationPositions.size()) {
                if (this.manualHyphenationPositions.get(i) > position) {
                    rightChunk.addManualHyphenationPosition(this.manualHyphenationPositions.get(i) - position);
                    this.manualHyphenationPositions.remove(i);
                }
                ++i;
            }
            int index = this.attributedText.chunks.indexOf(this);
            this.attributedText.chunks.add(index + 1, rightChunk);
            this.attributedText.deleteTextMenu(this.textMenu);
            this.calculateMetrics();
        }
    }

    @Override
    public void merge(ArrayList<Chunk> chunks) {
        Chunk nextChunk = null;
        int index = chunks.indexOf(this);
        if (index >= 0 && index < chunks.size() - 1) {
            nextChunk = chunks.get(index + 1);
        }
        if (nextChunk != null && nextChunk.isTextChunk() && nextChunk.textStyle == this.textStyle) {
            TextChunk tc = (TextChunk)nextChunk;
            int oldTextLength = this.text.length();
            this.setText(String.valueOf(this.text) + tc.getText());
            for (Integer pos : tc.manualHyphenationPositions) {
                this.addManualHyphenationPosition(pos + oldTextLength);
            }
            if (this.textMenu != null) {
                this.textMenuTo = oldTextLength;
            } else if (tc.getTextMenu() != null) {
                this.setTextMenu(tc.getTextMenu());
                this.textMenuFrom = tc.getText().length();
            }
            this.calculateMetrics();
            chunks.remove(nextChunk);
        }
    }

    @Override
    public Chunk getCopyOfPart(int fromPosition, int toPosition) {
        TextChunk copy = new TextChunk(this.text.substring(fromPosition, toPosition), this.attributedText);
        copy.setTextStyle(this.textStyle);
        copy.calculateMetrics();
        return copy;
    }

    @Override
    public Chunk getCopy() {
        TextChunk copy = new TextChunk(this.text, this.attributedText);
        copy.setTextStyle(this.textStyle);
        copy.calculateMetrics();
        return copy;
    }

    @Override
    public ChunkPosition getHitPosition(float x, float y, Line line, float chunkX, float chunkBaseline, int startPos) {
        int charIndex = this.textStyle.getCursorPos(String.valueOf(this.text.substring(startPos)) + "x", x -= chunkX, y -= chunkBaseline);
        if ((charIndex += startPos) < 0) {
            charIndex = 0;
        }
        if (charIndex > this.text.length()) {
            charIndex = this.text.length();
        }
        if (Settings.getInstance().getToggleEditModus() == Settings.ToggleEditModus.fillIn && !this.term.isEmpty()) {
            charIndex = charIndex < this.text.length() / 2 ? 0 : this.text.length();
        }
        ChunkPosition cp = new ChunkPosition(this, charIndex);
        cp.normalizeStringEndTo0();
        return cp;
    }

    @Override
    public PointFloat getPosition(float xp, float yp, int position, Line line) {
        PointFloat pos = new PointFloat(this.textStyle.getStringAdvance(this.text, 0, position) + xp, yp);
        return pos;
    }

    @Override
    public Chunk getSubChunkLeft(int toPosition) {
        if (toPosition > 0) {
            TextChunk tc = (TextChunk)this.getCopy();
            tc.setText(this.text.substring(0, toPosition));
            for (Integer pos : this.manualHyphenationPositions) {
                if (pos >= toPosition) continue;
                tc.addManualHyphenationPosition(pos);
            }
            return tc;
        }
        return null;
    }

    @Override
    public Chunk getSubChunkMid(int fromPosition, int toPosition) {
        if (toPosition > 0 && fromPosition < this.text.length() && toPosition > fromPosition) {
            TextChunk tc = (TextChunk)this.getCopy();
            tc.setText(this.text.substring(fromPosition, toPosition));
            for (Integer pos : this.manualHyphenationPositions) {
                if (pos <= fromPosition || pos >= toPosition) continue;
                tc.addManualHyphenationPosition(pos - fromPosition);
            }
            return tc;
        }
        return null;
    }

    @Override
    public Chunk getSubChunkRight(int fromPosition) {
        if (fromPosition < this.text.length()) {
            TextChunk tc = (TextChunk)this.getCopy();
            tc.setText(this.text.substring(fromPosition, this.text.length()));
            for (Integer pos : this.manualHyphenationPositions) {
                if (pos <= fromPosition) continue;
                tc.addManualHyphenationPosition(pos - fromPosition);
            }
            return tc;
        }
        return null;
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + this.getIndex() + " TC: " + super.toString() + " Text: " + this.text;
        return s;
    }

    @Override
    public void deSerialize(Element element) {
    }

    @Override
    public Element serialize(Element parentElement) {
        return null;
    }

    @Override
    public String getAsString() {
        return this.text;
    }

    public SpellingState getSpellingState() {
        return this.spellingState;
    }

    public void setSpellingState(SpellingState spellingState) {
        this.spellingState = spellingState;
    }

    public void addSpellTask() {
        if (this.text.length() > 1) {
            this.spellingState = SpellingState.getsChecked;
            SpellTask spellTask = new SpellTask(this, this.text);
            SpellTasks spellTasks = Spellchecker.getInstance().getSpellTasks();
            spellTasks.add(spellTask);
        } else {
            this.spellingState = SpellingState.correct;
        }
    }

    public boolean isSpellingCorrect() {
        return this.spellingState != SpellingState.incorrect;
    }

    public float getAdvance(int startPos, int endPos) {
        String s = this.text.substring(startPos, endPos);
        if (this.term.isEmpty()) {
            return this.textStyle.getStringAdvance(s, 0, s.length());
        }
        float adv = this.textStyle.getStringAdvance(s, 0, s.length());
        float minimumWhitespacewidth = this.textStyle.getWhiteSpaceWidth();
        int i = 1;
        while (i < s.length() - 1) {
            if (s.charAt(i) == ' ') {
                adv += this.whiteSpaceWidth - minimumWhitespacewidth;
            }
            ++i;
        }
        return adv;
    }

    public void storeJustifiedAdvance() {
        if (!this.term.isEmpty()) {
            this.advance = this.getAdvance(0, this.text.length());
        }
    }

    public float getTextWidthWithHyphen(int startPosition, int endPosition) {
        String hyphen = this.text.charAt(endPosition) == ' ' ? "" : "-";
        String s = String.valueOf(this.text.substring(startPosition, endPosition)) + hyphen;
        return (float)this.textStyle.getStringBounds(s).getWidth();
    }

    public ArrayList<Integer> getManualHyphenationPositions() {
        return this.manualHyphenationPositions;
    }

    public boolean hasManualHyphenationPositions() {
        return this.manualHyphenationPositions.size() > 0;
    }

    public boolean isManualHyphenationPosition(int pos) {
        for (Integer i : this.manualHyphenationPositions) {
            if (i == pos) {
                return true;
            }
            if (i <= pos) continue;
            return false;
        }
        return false;
    }

    public void changeToEditMode() {
        if (!this.term.isEmpty()) {
            this.text = this.textInEditMode;
        }
    }

    public float getWhiteSpaceWidth() {
        return this.whiteSpaceWidth;
    }

    public void setWhiteSpaceWidth(float whiteSpaceWidth) {
        this.whiteSpaceWidth = whiteSpaceWidth;
    }

    public void setWhiteSpaceWidthToMinimum() {
        this.whiteSpaceWidth = this.textStyle.getWhiteSpaceWidth();
    }

    public void switchEditMode(Settings.ToggleEditModus editmode) {
        switch (editmode) {
            case edit: {
                this.changeToEditMode();
                break;
            }
            case fillIn: {
                break;
            }
        }
    }

    public TextMenu getTextMenu() {
        return this.textMenu;
    }

    public void setTextMenu(TextMenu textMenu) {
        this.textMenu = textMenu;
        this.textMenuFrom = 0;
        this.textMenuTo = this.text.length();
    }

    public boolean hasTextMenu() {
        return this.textMenu != null;
    }

    public int getTextMenuFrom() {
        return this.textMenuFrom;
    }

    public int getTextMenuTo() {
        return this.textMenuTo;
    }

    public void setTextMenuFrom(int textMenuFrom) {
        this.textMenuFrom = textMenuFrom;
    }

    public void setTextMenuTo(int textMenuTo) {
        this.textMenuTo = textMenuTo;
    }
}

