/*
 * Decompiled with CFR 0.152.
 */
package document.text.hyphenation;

import document.text.hyphenation.Hyphenator;
import document.text.hyphenation.TableBasedHyphenator;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import util.io.IO;

public class Hyphenation {
    private static Hyphenation instance;
    private Hyphenator hyphenator;
    private HashMap<String, byte[]> complicatedWords = new HashMap(2000);

    public static Hyphenation getInstance() {
        if (instance == null) {
            instance = new Hyphenation();
        }
        return instance;
    }

    public static void freeMemory() {
        instance = null;
    }

    public Hyphenation() {
        this.hyphenator = new TableBasedHyphenator();
        this.retrieveComplicatedWors(this.hyphenator.getComplicatedWordsFilename());
    }

    public byte[] getHyphenationArray(String s) {
        int i;
        byte[] temp;
        byte[] retStrArr = this.complicatedWords.get(s.toLowerCase());
        if (retStrArr == null) {
            retStrArr = this.hyphenator.getHyphenationArray(s);
        }
        if (retStrArr.length > 0 && retStrArr[0] == 1) {
            temp = new byte[retStrArr.length - 1];
            i = 1;
            while (i < retStrArr.length) {
                temp[i - 1] = retStrArr[i];
                ++i;
            }
            retStrArr = temp;
        }
        if (retStrArr.length > 0 && retStrArr[retStrArr.length - 1] == retStrArr.length - 1) {
            temp = new byte[retStrArr.length - 1];
            i = 1;
            while (i < retStrArr.length) {
                temp[i] = retStrArr[i];
                ++i;
            }
            retStrArr = temp;
        }
        return retStrArr;
    }

    public String getSpelledWord(String word) {
        byte[] positions = this.getHyphenationArray(word);
        int from = 0;
        int to = 0;
        String ret = "";
        int i = 0;
        while (i <= positions.length) {
            if (i < positions.length) {
                to = positions[i];
                ret = String.valueOf(ret) + word.substring(from, to) + "-";
            } else {
                to = word.length();
                ret = String.valueOf(ret) + word.substring(from, to);
            }
            from = to;
            ++i;
        }
        return ret;
    }

    private void retrieveComplicatedWors(String filename) {
        try {
            InputStreamReader reader = new InputStreamReader(IO.openDataFile(filename));
            byte[] posz = new byte[200];
            try {
                int c;
                while ((c = ((Reader)reader).read()) != -1) {
                    String word = "" + (char)c;
                    if ((char)c == '.') continue;
                    while ((c = ((Reader)reader).read()) != 59) {
                        word = String.valueOf(word) + (char)c;
                    }
                    int count = 0;
                    while ((c = ((Reader)reader).read()) != 46) {
                        posz[count++] = (byte)(c - 97);
                    }
                    byte[] positions = new byte[count];
                    int i = 0;
                    while (i < count) {
                        positions[i] = posz[i];
                        ++i;
                    }
                    this.complicatedWords.put(word.toLowerCase(), positions);
                }
            }
            finally {
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }
}

