/*
 * Decompiled with CFR 0.152.
 */
package document.view;

import document.Serializable;
import document.view.MyView;
import gui.components.pageviewport.graphiccontext.ViewportGraphicContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Line2D;
import org.w3c.dom.Element;
import util.math.PointDouble;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class Grid
implements Serializable {
    private float originX = 0.0f;
    private float originY = 0.0f;
    private float delta = 0.5f;
    private float visibleDelta = 1.0f;
    private final Color gridLineColor = new Color(0xE0FFE0);
    private MyView view;

    public Grid(MyView view) {
        this.view = view;
    }

    public float getDelta() {
        return this.delta;
    }

    public void setDelta(float delta) {
        this.delta = delta;
    }

    public float getVisibleDelta() {
        return this.visibleDelta;
    }

    public void setVisibleDelta(float visibleDelta) {
        this.visibleDelta = visibleDelta;
    }

    public void drawGridLines(ViewportGraphicContext vgc) {
        if (this.visibleDelta > 0.0f) {
            Line2D.Float line;
            float pixelWidth = 1.0f / (float)vgc.getTransform().getScaleX();
            float height = (float)vgc.getPageHeightCm() - pixelWidth;
            float width = (float)vgc.getPageWidthCm() - pixelWidth;
            float minX = (float)((int)((0.0f - this.originX) / this.visibleDelta)) * this.visibleDelta;
            float minY = (float)((int)((0.0f - this.originY) / this.visibleDelta)) * this.visibleDelta;
            float x = minX;
            float y = minY;
            vgc.setColor(this.gridLineColor);
            vgc.setStroke(new BasicStroke(pixelWidth));
            while ((double)x <= (double)width + 1.0E-6) {
                line = new Line2D.Float(x, 0.0f, x, height);
                vgc.draw(line);
                x += this.visibleDelta;
            }
            while ((double)y <= (double)height + 1.0E-6) {
                line = new Line2D.Float(0.0f, y, width, y);
                vgc.draw(line);
                y += this.visibleDelta;
            }
        }
    }

    public void snap(PointDouble p, PointDouble positionToAlter) {
        if (this.delta > 0.0f) {
            double x = this.getNextXPositionOnGrid(p.x);
            double y = this.getNextYPositoinOnGrid(p.y);
            positionToAlter.x += x - p.x;
            positionToAlter.y += y - p.y;
        }
    }

    public double getNextXPositionOnGrid(double x) {
        return (float)Math.round((x - (double)this.originX) / (double)this.delta) * this.delta + this.originX;
    }

    public double getNextYPositoinOnGrid(double y) {
        return (float)Math.round((y - (double)this.originY) / (double)this.delta) * this.delta + this.originY;
    }

    @Override
    public void deSerialize(Element element) {
        Float z = XMLReader.elementFloatAttribute(element, "originx");
        if (z != null) {
            this.originX = z.floatValue();
        }
        if ((z = XMLReader.elementFloatAttribute(element, "originy")) != null) {
            this.originY = z.floatValue();
        }
        if ((z = XMLReader.elementFloatAttribute(element, "delta")) != null) {
            this.delta = z.floatValue();
        }
        if ((z = XMLReader.elementFloatAttribute(element, "visibledelta")) != null) {
            this.visibleDelta = z.floatValue();
        }
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(Grid.getXMLName(), parentElement);
        XMLWriter.addAttributeFloat(element, "originx", this.originX);
        XMLWriter.addAttributeFloat(element, "originy", this.originY);
        XMLWriter.addAttributeFloat(element, "delta", this.delta);
        XMLWriter.addAttributeFloat(element, "visibledelta", this.visibleDelta);
        return element;
    }

    public static String getXMLName() {
        return "grid";
    }

    public MyView getView() {
        return this.view;
    }

    public Grid getCopy(MyView newView) {
        Grid copyGrid = new Grid(newView);
        copyGrid.delta = this.delta;
        copyGrid.originX = this.originX;
        copyGrid.originY = this.originY;
        copyGrid.visibleDelta = this.visibleDelta;
        return copyGrid;
    }
}

