/*
 * Decompiled with CFR 0.152.
 */
package gui.actions;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import document.MyDocument;
import document.MyPage;
import document.view.MyView;
import gui.actions.MyAction;
import gui.components.mainpanel.MainPanelController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.graphiccontext.PdfGraphicContext;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JFileChooser;
import renderer.g2dRenderer.G2dRenderer;
import util.io.PDFFilter;

public class SaveAsPdfAction
extends MyAction {
    private static final long serialVersionUID = 1L;
    private static SaveAsPdfAction instance;

    public static SaveAsPdfAction getInstance() {
        if (instance == null) {
            instance = new SaveAsPdfAction();
        }
        return instance;
    }

    private SaveAsPdfAction() {
        super("Als pdf speichern...", "data/img/menu/16/page_white_acrobat.png");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MyDocument document;
        MyView view;
        PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new PDFFilter());
        int returnVal = fc.showSaveDialog(MainPanelController.getInstance().getMainPanel());
        if (returnVal == 0 && (view = (document = controller.getDocument()).getPrintView()) != null && view.pages.size() > 0) {
            Document pdfDocument = new Document();
            try {
                File file = fc.getSelectedFile();
                if (!file.getName().endsWith("pdf")) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + ".pdf");
                }
                PdfWriter writer = PdfWriter.getInstance(pdfDocument, new FileOutputStream(file.getAbsolutePath()));
                pdfDocument.open();
                PdfContentByte cb = writer.getDirectContent();
                cb.saveState();
                float dotsPerCm = 28.346457f;
                Graphics g2d = null;
                MyPage firstPage = view.pages.get(0);
                int i = 0;
                while (i < view.pages.size()) {
                    g2d = cb.createGraphics((float)firstPage.getWidthcm() * 28.346457f, (float)firstPage.getHeightcm() * 28.346457f);
                    PdfGraphicContext pgc = new PdfGraphicContext(28.34645652770996, 1.0, 0, 0, firstPage.getWidthcm(), firstPage.getHeightcm(), (Graphics2D)g2d);
                    G2dRenderer renderer = new G2dRenderer(pgc);
                    renderer.render(view.getPage(i), false);
                    if (i < view.pages.size() - 1) {
                        g2d.dispose();
                        cb.restoreState();
                        pdfDocument.newPage();
                        cb.saveState();
                    }
                    ++i;
                }
                g2d.dispose();
                cb.restoreState();
            }
            catch (Exception exception) {
                // empty catch block
            }
            pdfDocument.close();
        }
    }

    @Override
    protected void dispose() {
        instance = null;
    }
}

