/*
 * Decompiled with CFR 0.152.
 */
package gui.components.attributepanel;

import document.Scriptable;
import javax.swing.table.AbstractTableModel;
import util.language.Lang;

public class EventTableModel
extends AbstractTableModel {
    private Scriptable scriptable;
    private final String[] columnNames = new String[]{"Ereignisse:"};

    public EventTableModel(Scriptable scriptable) {
        this.scriptable = scriptable;
    }

    @Override
    public int getColumnCount() {
        if (this.scriptable == null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getRowCount() {
        if (this.scriptable != null && this.scriptable.getPossibleEvents() != null) {
            return this.scriptable.getPossibleEvents().length;
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.scriptable != null) {
            switch (columnIndex) {
                case 0: {
                    boolean empty = this.scriptable.getScript(this.scriptable.getPossibleEvents()[rowIndex]) == null;
                    String prefix = "";
                    if (!empty) {
                        prefix = "(!) ";
                    }
                    return String.valueOf(prefix) + this.scriptable.getPossibleEvents()[rowIndex].toString();
                }
            }
            return "";
        }
        return "";
    }

    public Scriptable getScriptable() {
        return this.scriptable;
    }

    public void setScriptable(Scriptable scriptable) {
        this.scriptable = scriptable;
    }

    @Override
    public String getColumnName(int column) {
        return Lang.get(this.columnNames[column]);
    }
}

