/*
 * Decompiled with CFR 0.152.
 */
package gui.components.bemerkungspanel;

import gui.components.bemerkungspanel.KeyData;
import gui.components.bemerkungspanel.PlaceholderMap;
import java.util.ArrayList;

public class Bemerkung {
    private ArrayList<String> textsWithPlaceHolders = new ArrayList();
    private ArrayList<PlaceholderMap> placeholderMaps = new ArrayList();
    private int number;
    private String level = "";
    private String field = "";
    private String subfield = "";
    private KeyData keyData = null;

    public void setKeyData(KeyData keyData) {
        this.keyData = keyData;
    }

    private boolean isDigit(char c) {
        return c == '0' || c >= '1' && c <= '9';
    }

    public void addStringWithMaps(String textWithPlaceHolders, String placeholderMapString) {
        int i = 0;
        while (i < textWithPlaceHolders.length() && textWithPlaceHolders.charAt(i) != '_') {
            ++i;
        }
        try {
            this.number = Integer.parseInt(textWithPlaceHolders.substring(0, i));
            this.field = textWithPlaceHolders.substring(++i, i + 4);
            this.subfield = String.valueOf(this.field) + "_" + textWithPlaceHolders.substring(i += 5, i + 3);
            this.level = textWithPlaceHolders.substring(i += 4, i + 1);
            this.textsWithPlaceHolders.add(textWithPlaceHolders.substring(i += 2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        i = 0;
        while (i < placeholderMapString.length()) {
            PlaceholderMap pm = new PlaceholderMap();
            i = pm.init(placeholderMapString, i);
            this.placeholderMaps.add(pm);
            pm.setIndexOfStringWithPlaceholders(this.textsWithPlaceHolders.size() - 1);
        }
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getSubfield() {
        return this.subfield;
    }

    public void setSubfield(String subfield) {
        this.subfield = subfield;
    }

    public String getBemerkung(String type, String name) {
        boolean[] validMaps = new boolean[this.placeholderMaps.size()];
        int i = 0;
        while (i < validMaps.length) {
            validMaps[i] = true;
            ++i;
        }
        PlaceholderMap phm = this.placeholderMaps.get(0);
        char[] validChars = new char[]{type.charAt(0), 'b'};
        this.setUnValid(0, validChars, validMaps);
        phm = this.getFirstValidMap(validMaps, phm);
        validChars[1] = type.charAt(0);
        this.setUnValid(0, validChars, validMaps);
        phm = this.getFirstValidMap(validMaps, phm);
        validChars[0] = type.charAt(2);
        validChars[1] = type.charAt(2);
        this.setUnValid(2, validChars, validMaps);
        phm = this.getFirstValidMap(validMaps, phm);
        validChars[0] = type.charAt(1);
        validChars[1] = 117;
        this.setUnValid(1, validChars, validMaps);
        phm = this.getFirstValidMap(validMaps, phm);
        validChars[1] = type.charAt(1);
        this.setUnValid(1, validChars, validMaps);
        phm = this.getFirstValidMap(validMaps, phm);
        return this.getBemerkung(phm, this.textsWithPlaceHolders.get(phm.getIndexOfStringWithPlaceholders()), name);
    }

    private String getBemerkung(PlaceholderMap phm, String string, String name) {
        String s = string;
        int i = 0;
        while (i < phm.getPlaceholders().length) {
            String placeHolderValue = phm.getPlaceholders()[i];
            if (placeHolderValue.compareTo("VN") == 0) {
                placeHolderValue = name;
            }
            String toSubstitute = "/" + (i + 1);
            s = s.replace(toSubstitute, placeHolderValue);
            ++i;
        }
        return s;
    }

    private void setUnValid(int column, char[] validChars, boolean[] validMaps) {
        boolean[] oldValidMaps = new boolean[validMaps.length];
        int i = 0;
        while (i < validMaps.length) {
            oldValidMaps[i] = validMaps[i];
            String type = this.placeholderMaps.get(i).getType();
            boolean valid = false;
            int j = 0;
            while (j < validChars.length) {
                String validChar = "" + validChars[j];
                if (validChar.compareToIgnoreCase(type.substring(column, column + 1)) == 0) {
                    valid = true;
                    break;
                }
                ++j;
            }
            validMaps[i] = validMaps[i] && valid;
            ++i;
        }
        boolean allFalse = true;
        int i2 = 0;
        while (i2 < validMaps.length) {
            if (validMaps[i2]) {
                allFalse = false;
                break;
            }
            ++i2;
        }
        if (allFalse) {
            i2 = 0;
            while (i2 < validMaps.length) {
                validMaps[i2] = oldValidMaps[i2];
                ++i2;
            }
        }
    }

    private PlaceholderMap getFirstValidMap(boolean[] validMaps, PlaceholderMap phm) {
        int i = 0;
        while (i < validMaps.length) {
            if (validMaps[i]) {
                return this.placeholderMaps.get(i);
            }
            ++i;
        }
        return phm;
    }

    public String toString() {
        if (this.keyData == null) {
            return this.textsWithPlaceHolders.get(0);
        }
        return this.getBemerkung(this.keyData.getType(), this.keyData.getName());
    }
}

