/*
 * Decompiled with CFR 0.152.
 */
package gui.components.bemerkungspanel;

import gui.components.bemerkungspanel.Bemerkung;
import gui.components.bemerkungspanel.Bemerkungen;
import gui.components.bemerkungspanel.BemerkungsList;
import gui.components.bemerkungspanel.BemerkungsListRenderer;
import gui.components.bemerkungspanel.BemerkungsPanelController;
import gui.components.bemerkungspanel.KeyData;
import gui.components.mainpanel.MainPanelController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import util.io.IO;
import util.language.Lang;

public class BemerkungsPanel
extends JPanel
implements ActionListener {
    private JRadioButton rbMaennlich;
    private JRadioButton rbWeiblich;
    private JRadioButton rbGegenwart;
    private JRadioButton rbVergangenheit;
    private JRadioButton rbName;
    private JRadioButton rbFuerwort;
    private ButtonGroup groupMW = new ButtonGroup();
    private ButtonGroup groupGV = new ButtonGroup();
    private ButtonGroup groupNF = new ButtonGroup();
    private JPanel panelLevel = new JPanel();
    private JRadioButton[] rbLevels;
    private JPanel panelSubfield = new JPanel();
    private JRadioButton[] rbSubfields;
    private BemerkungsList bemerkungsList = new BemerkungsList();
    private ArrayList<Bemerkung> bemerkungen = new ArrayList();
    private Bemerkungen alleBemerkungen = null;
    private BemerkungsPanelController controller;
    private String vorname = "";
    private JPanel eastCenterPanel;
    private JButton buttonInsert;
    private JPanel eastPanel;
    private ImageIcon iconCancel;
    private ImageIcon iconCancelHighlighted;
    private JLabel labelClose;

    public BemerkungsPanel(BemerkungsPanelController controller) {
        this.controller = controller;
        this.setLayout(new BorderLayout());
        this.bemerkungsList.setCellRenderer(new BemerkungsListRenderer());
        JScrollPane scrollPane = new JScrollPane(this.bemerkungsList);
        this.add((Component)scrollPane, "Center");
        this.eastPanel = new JPanel();
        this.add((Component)this.eastPanel, "East");
        this.eastPanel.setLayout(new BorderLayout());
        JPanel insertButtonPanel = new JPanel();
        insertButtonPanel.setLayout(new FlowLayout(1));
        insertButtonPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
        this.buttonInsert = new JButton(Lang.get("Einf\u00fcgen"));
        this.buttonInsert.setIcon(IO.loadImage("data/img/menu/16/editpaste.png"));
        this.buttonInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BemerkungsPanel.this.insertButtonpressed();
            }
        });
        insertButtonPanel.add(this.buttonInsert);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)insertButtonPanel, "Center");
        JPanel buttonPanelWest = new JPanel();
        buttonPanelWest.setPreferredSize(new Dimension(30, 20));
        buttonPanel.add((Component)buttonPanelWest, "West");
        JPanel buttonPanelEast = new JPanel();
        buttonPanelEast.setPreferredSize(new Dimension(50, 20));
        buttonPanel.add((Component)buttonPanelEast, "East");
        buttonPanelEast.setLayout(new FlowLayout(2));
        this.iconCancel = IO.loadImage("data/img/menu/16/cancel.png");
        this.iconCancelHighlighted = IO.loadImage("data/img/menu/16/cancelhighlighted.png");
        this.labelClose = new JLabel(this.iconCancel);
        this.labelClose.setToolTipText(Lang.get("Textbausteine ausblenden"));
        this.labelClose.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MainPanelController.getInstance().enableBemerkungsSplitPane(false);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BemerkungsPanel.this.setLabelCloseIcon(BemerkungsPanel.this.iconCancelHighlighted);
                super.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BemerkungsPanel.this.setLabelCloseIcon(BemerkungsPanel.this.iconCancel);
                super.mouseExited(e);
            }
        });
        buttonPanelEast.add(this.labelClose);
        this.eastPanel.add((Component)buttonPanel, "North");
        this.eastCenterPanel = new JPanel();
        this.eastCenterPanel.setLayout(new BorderLayout());
        this.eastPanel.add((Component)this.eastCenterPanel, "Center");
        JPanel wishPanel = new JPanel();
        Border loweredBorder = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(loweredBorder, Lang.get("Wunschform"));
        wishPanel.setBorder(titledBorder);
        wishPanel.setLayout(new GridLayout(3, 2, 2, 2));
        this.rbMaennlich = new JRadioButton(Lang.get("m\u00e4nnlich"));
        this.rbWeiblich = new JRadioButton(Lang.get("weiblich"));
        this.rbGegenwart = new JRadioButton(Lang.get("Gegenwart"));
        this.rbVergangenheit = new JRadioButton(Lang.get("Vergangenheit"));
        this.rbName = new JRadioButton(Lang.get("Name"));
        this.rbFuerwort = new JRadioButton(Lang.get("F\u00fcrwort"));
        this.rbMaennlich.addActionListener(this);
        this.rbWeiblich.addActionListener(this);
        this.rbGegenwart.addActionListener(this);
        this.rbVergangenheit.addActionListener(this);
        this.rbName.addActionListener(this);
        this.rbFuerwort.addActionListener(this);
        wishPanel.add(this.rbMaennlich);
        wishPanel.add(this.rbWeiblich);
        wishPanel.add(this.rbGegenwart);
        wishPanel.add(this.rbVergangenheit);
        wishPanel.add(this.rbName);
        wishPanel.add(this.rbFuerwort);
        this.groupMW.add(this.rbMaennlich);
        this.groupMW.add(this.rbWeiblich);
        this.groupGV.add(this.rbGegenwart);
        this.groupGV.add(this.rbVergangenheit);
        this.groupNF.add(this.rbName);
        this.groupNF.add(this.rbFuerwort);
        Border loweredBorderLevel = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorderLevel = BorderFactory.createTitledBorder(loweredBorderLevel, Lang.get("Level"));
        this.panelLevel.setBorder(titledBorderLevel);
        Border loweredBorderSubfield = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorderSubfield = BorderFactory.createTitledBorder(loweredBorderSubfield, Lang.get("Unterkategorie"));
        this.panelSubfield.setBorder(titledBorderSubfield);
        this.eastPanel.add((Component)wishPanel, "South");
        this.eastPanel.add((Component)this.panelLevel, "West");
        this.eastCenterPanel.add((Component)this.panelSubfield, "Center");
        this.setRecursiveFocusable(this, false);
    }

    private void setLabelCloseIcon(ImageIcon icon) {
        this.labelClose.setIcon(icon);
    }

    protected void insertButtonpressed() {
        Object[] bemerkungen;
        PageViewPortController pc = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
        pc.getCursorController().setEnabled(false);
        Object[] objectArray = bemerkungen = this.bemerkungsList.getSelectedValues();
        int n = bemerkungen.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Bemerkung b = (Bemerkung)o;
            this.controller.insertBemerkung(b.toString());
            this.controller.setupBemerkungen();
            ++n2;
        }
        pc.updateCursor(false);
        pc.addJobPaintActiveTextfield(false);
        pc.getCursorController().setEnabled(true);
    }

    public void setupSubfieldPanel(ArrayList<String> subfields) {
        this.eastCenterPanel.remove(this.panelSubfield);
        this.rbSubfields = null;
        if (subfields.size() > 1) {
            this.eastCenterPanel.add((Component)this.panelSubfield, "Center");
            subfields.add("alle");
            this.panelSubfield.removeAll();
            this.panelSubfield.setLayout(new GridLayout(0, 2));
            ButtonGroup bg = new ButtonGroup();
            this.rbSubfields = new JRadioButton[subfields.size()];
            int i = 0;
            while (i < subfields.size()) {
                JRadioButton rb = new JRadioButton(this.alleBemerkungen.getSubfieldLongform(subfields.get(i)));
                if (i == 0) {
                    rb.setSelected(true);
                }
                this.rbSubfields[i] = rb;
                rb.addActionListener(this);
                bg.add(rb);
                this.panelSubfield.add(rb);
                ++i;
            }
        }
        this.setRecursiveFocusable(this, false);
    }

    public void setupLevelPanel(ArrayList<String> levels) {
        this.eastPanel.remove(this.panelLevel);
        if (levels.size() > 1) {
            this.panelLevel.removeAll();
            levels.add("alle");
            this.panelLevel.setLayout(new BoxLayout(this.panelLevel, 1));
            this.eastPanel.add((Component)this.panelLevel, "West");
            ButtonGroup bg = new ButtonGroup();
            this.rbLevels = new JRadioButton[levels.size()];
            int i = 0;
            while (i < levels.size()) {
                JRadioButton rb = new JRadioButton(levels.get(i));
                if (i == 0) {
                    rb.setSelected(true);
                }
                this.rbLevels[i] = rb;
                rb.addActionListener(this);
                bg.add(rb);
                this.panelLevel.add(rb);
                ++i;
            }
        } else {
            this.rbLevels = null;
        }
        this.setRecursiveFocusable(this, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateBemerkungsList(this.vorname);
    }

    public ArrayList<Bemerkung> getBemerkungen() {
        return this.bemerkungen;
    }

    public void setBemerkungen(ArrayList<Bemerkung> bemerkungen) {
        this.bemerkungen = bemerkungen;
    }

    public void updateBemerkungsList(String name) {
        int n;
        char sex = 'm';
        if (this.rbWeiblich.isSelected()) {
            sex = 'w';
        }
        char nameFuerwort = 'p';
        if (this.rbFuerwort.isSelected()) {
            nameFuerwort = 'u';
        }
        char time = 'v';
        if (this.rbGegenwart.isSelected()) {
            time = 'g';
        }
        String type = "" + sex + nameFuerwort + time;
        KeyData keyData = new KeyData(name, type);
        ArrayList<Bemerkung> filteredBemerkungen = new ArrayList<Bemerkung>();
        String level = "";
        if (this.rbLevels != null) {
            JRadioButton[] jRadioButtonArray = this.rbLevels;
            n = this.rbLevels.length;
            int n2 = 0;
            while (n2 < n) {
                JRadioButton rb = jRadioButtonArray[n2];
                if (rb.isSelected()) {
                    level = rb.getText();
                    break;
                }
                ++n2;
            }
        }
        String subField = "";
        if (this.rbSubfields != null) {
            JRadioButton[] jRadioButtonArray = this.rbSubfields;
            int n3 = this.rbSubfields.length;
            n = 0;
            while (n < n3) {
                JRadioButton rb = jRadioButtonArray[n];
                if (rb.isSelected()) {
                    subField = this.alleBemerkungen.getSubfieldShortform(rb.getText());
                    break;
                }
                ++n;
            }
        }
        for (Bemerkung bemerkung : this.bemerkungen) {
            if (!level.isEmpty() && level.compareTo(bemerkung.getLevel()) != 0 && level.compareTo("alle") != 0 || !subField.isEmpty() && subField.compareTo(bemerkung.getSubfield()) != 0 && subField.compareTo("alle") != 0) continue;
            bemerkung.setKeyData(keyData);
            filteredBemerkungen.add(bemerkung);
        }
        this.bemerkungsList.setBemerkungen(filteredBemerkungen);
    }

    @Override
    public void setName(String name) {
        this.vorname = name;
    }

    public void setRadiobuttonStatus(char sex, char time, char persoenlichFuerwort) {
        if (sex == 'm') {
            this.rbMaennlich.setSelected(true);
        } else {
            this.rbWeiblich.setSelected(true);
        }
        if (time == 'v') {
            this.rbVergangenheit.setSelected(true);
        } else {
            this.rbGegenwart.setSelected(true);
        }
        if (persoenlichFuerwort == 'p') {
            this.rbName.setSelected(true);
        } else {
            this.rbFuerwort.setSelected(true);
        }
    }

    private void setRecursiveFocusable(Component c, boolean isFocusable) {
        c.setFocusable(isFocusable);
        if (c instanceof JComponent) {
            Component[] componentArray = ((JComponent)c).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                this.setRecursiveFocusable(comp, isFocusable);
                ++n2;
            }
        }
    }

    public void setAlleBemerkungen(Bemerkungen alleBemerkungen) {
        this.alleBemerkungen = alleBemerkungen;
    }
}

