/*
 * Decompiled with CFR 0.152.
 */
package gui.components.choosepupilpanel;

import data.localdatabase.DBExchangeObject;
import data.localdatabase.DBKlassenDaten;
import data.localdatabase.DBSchuelerDaten;
import data.localdatabase.DBSchulDaten;
import data.localdatabase.DBZeugnisDaten;
import data.localdatabase.DataProvider;
import gui.actions.usermode.SaveActionUserMode;
import gui.actions.usermode.SaveAsActionUserMode;
import gui.components.choosepupilpanel.GermanStringComperator;
import gui.components.choosepupilpanel.PupilTableModel;
import gui.components.mainpanel.MainPanelController;
import gui.nbcomponents.components.MyJLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;

public class ChoosePupilPanel
extends JPanel
implements ActionListener {
    private JTable pupilTable;
    private TableRowSorter<PupilTableModel> sorter;
    private JComboBox schoolComboBox;
    private JComboBox classComboBox;
    private JComboBox zeugnisComboBox;
    private DataProvider dataProvider;
    private int oldRowIndex = -1;

    public ChoosePupilPanel(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
        this.setLayout(new BorderLayout());
        this.pupilTable = new JTable();
        this.pupilTable.setSelectionMode(0);
        this.pupilTable.setRowSelectionAllowed(true);
        this.pupilTable.setColumnSelectionAllowed(false);
        this.pupilTable.getSelectionModel().addListSelectionListener(new RowListener());
        JScrollPane pupilPane = new JScrollPane(this.pupilTable);
        this.add((Component)pupilPane, "Center");
        JPanel northPanel = new JPanel();
        northPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        northPanel.setLayout(new BoxLayout(northPanel, 1));
        MyJLabel schoolLabel = new MyJLabel();
        schoolLabel.setText("Schule:");
        schoolLabel.setAlignmentX(0.0f);
        northPanel.add(schoolLabel);
        this.schoolComboBox = new JComboBox();
        this.schoolComboBox.setAlignmentX(0.0f);
        northPanel.add(this.schoolComboBox);
        northPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        MyJLabel classLabel = new MyJLabel();
        classLabel.setText("Klasse:");
        classLabel.setAlignmentX(0.0f);
        northPanel.add(classLabel);
        this.classComboBox = new JComboBox();
        this.classComboBox.setAlignmentX(0.0f);
        northPanel.add(this.classComboBox);
        northPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        MyJLabel zeugnisLabel = new MyJLabel();
        zeugnisLabel.setText("Zeugnis:");
        zeugnisLabel.setAlignmentX(0.0f);
        northPanel.add(zeugnisLabel);
        this.zeugnisComboBox = new JComboBox();
        this.zeugnisComboBox.setAlignmentX(0.0f);
        northPanel.add(this.zeugnisComboBox);
        this.add((Component)northPanel, "North");
        this.setupSchoolComboBox();
        if (this.pupilTable.getModel().getRowCount() > 0) {
            this.selectPupilRow(0);
        }
        this.classComboBox.addActionListener(this);
        this.schoolComboBox.addActionListener(this);
        this.zeugnisComboBox.addActionListener(this);
    }

    public void selectPupilRow(int row) {
        if (this.pupilTable.getModel().getRowCount() > 0) {
            this.pupilTable.setRowSelectionInterval(row, row);
        }
    }

    private void pupilTableSelectionChanged(int rowIndex) {
        if (rowIndex != this.oldRowIndex) {
            this.setWaitCursor();
            DBSchuelerDaten schueler = ((DBKlassenDaten)this.classComboBox.getSelectedItem()).getSchueler().get(rowIndex);
            DBZeugnisDaten zeugnis = (DBZeugnisDaten)this.zeugnisComboBox.getSelectedItem();
            DBSchulDaten schule = (DBSchulDaten)this.schoolComboBox.getSelectedItem();
            DBKlassenDaten klasse = (DBKlassenDaten)this.classComboBox.getSelectedItem();
            MainPanelController.getInstance().choosePupilAndZeugnis(schueler, zeugnis, schule, klasse);
            this.setDefaultCursor();
        }
    }

    public void setDataProvidedStatus() {
        this.setupSchoolComboBox();
        boolean dataProvided = this.schoolComboBox.getItemCount() > 0;
        MainPanelController.getInstance().enableSouthEastPanel(dataProvided);
        SaveActionUserMode.getInstance().setEnabled(dataProvided);
        SaveAsActionUserMode.getInstance().setEnabled(dataProvided);
    }

    public boolean isDataProvided() {
        return this.schoolComboBox.getItemCount() > 0;
    }

    private void setupSchoolComboBox() {
        DBExchangeObject eo = this.dataProvider.getExchangeObject();
        ArrayList<DBSchulDaten> schulen = eo.getSchulen(eo.getCurrentlyLoggedInUser());
        this.schoolComboBox.setModel(new DefaultComboBoxModel<Object>(schulen.toArray()));
        this.setupClassComboBox();
    }

    private void setupClassComboBox() {
        DBExchangeObject eo = this.dataProvider.getExchangeObject();
        DBSchulDaten schule = (DBSchulDaten)this.schoolComboBox.getSelectedItem();
        if (schule != null) {
            ArrayList<DBKlassenDaten> klassen = schule.getClasses(eo.getCurrentlyLoggedInUser());
            this.classComboBox.setModel(new DefaultComboBoxModel<Object>(klassen.toArray()));
            this.setupZeugnisComboBox();
        }
    }

    private void setupZeugnisComboBox() {
        DBKlassenDaten klasse = (DBKlassenDaten)this.classComboBox.getSelectedItem();
        if (klasse != null) {
            ArrayList<DBZeugnisDaten> zeugnisse = klasse.getZeugnisse();
            this.zeugnisComboBox.setModel(new DefaultComboBoxModel<Object>(zeugnisse.toArray()));
            this.setupPupilTable();
        }
    }

    private void setupPupilTable() {
        DBKlassenDaten klasse = (DBKlassenDaten)this.classComboBox.getSelectedItem();
        if (klasse != null) {
            PupilTableModel ptm = new PupilTableModel(klasse);
            this.pupilTable.setModel(ptm);
            this.pupilTable.getColumnModel().getColumn(0).setPreferredWidth(25);
            this.sorter = new TableRowSorter<PupilTableModel>(ptm);
            this.sorter.setComparator(1, new GermanStringComperator());
            this.sorter.setComparator(2, new GermanStringComperator());
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
            sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
            sortKeys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
            this.sorter.setSortKeys(sortKeys);
            this.pupilTable.setRowSorter(this.sorter);
            ptm.fireTableStructureChanged();
            this.pupilTable.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.schoolComboBox) {
            this.setupClassComboBox();
            this.setupZeugnisComboBox();
            this.setupPupilTable();
            if (this.pupilTable.getModel().getRowCount() > 0) {
                this.selectPupilRow(0);
            }
        }
        if (e.getSource() == this.classComboBox) {
            this.setupZeugnisComboBox();
            this.setupPupilTable();
            if (this.pupilTable.getModel().getRowCount() > 0) {
                this.selectPupilRow(0);
            }
        }
        if (e.getSource() == this.zeugnisComboBox) {
            this.pupilTableSelectionChanged(this.sorter.convertRowIndexToModel(this.pupilTable.getSelectionModel().getLeadSelectionIndex()));
        }
    }

    private void setWaitCursor() {
        MainPanelController.getInstance().setCursor(Cursor.getPredefinedCursor(3));
    }

    private void setDefaultCursor() {
        MainPanelController.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    private class RowListener
    implements ListSelectionListener {
        private RowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            int rowIndex = ChoosePupilPanel.this.pupilTable.getSelectionModel().getLeadSelectionIndex();
            if (rowIndex >= 0) {
                ChoosePupilPanel.this.pupilTableSelectionChanged(ChoosePupilPanel.this.sorter.convertRowIndexToModel(rowIndex));
            }
        }
    }
}

