/*
 * Decompiled with CFR 0.152.
 */
package gui.components.mainpanel;

import gui.components.mainpanel.MainPanelController;
import gui.components.toolbars.CommandBar;
import gui.components.toolbars.DrawBar;
import gui.components.toolbars.EditBar;
import gui.components.toolbars.EditModusBar;
import gui.components.toolbars.MyJToolBar;
import gui.components.toolbars.TextStyleBar;
import gui.layout.DockLayout;
import init.Settings;
import java.awt.Component;
import javax.swing.JPanel;

public class MainPanel
extends JPanel {
    MyJToolBar drawBar;
    MyJToolBar editBar;
    MyJToolBar textStyleBar;
    MyJToolBar editModusBar;
    MyJToolBar commandBar;
    MainPanelController controller;

    public MainPanel(MainPanelController controller) {
        this.controller = controller;
        this.setLayout(new DockLayout());
        this.editModusBar = new EditModusBar();
        this.drawBar = DrawBar.getInstance();
        this.editBar = EditBar.getInstance();
        this.textStyleBar = TextStyleBar.getInstance();
        this.commandBar = CommandBar.getInstance();
        this.setupToolbars(false, false, false, false, false);
    }

    public void setupToolbarsAccordingToToggleEditMode(boolean documentExists) {
        boolean isEditMode = Settings.getInstance().getToggleEditModus() == Settings.ToggleEditModus.edit;
        isEditMode = isEditMode && documentExists;
        this.setupToolbars(documentExists, isEditMode, documentExists, documentExists, isEditMode);
    }

    public void setupToolbars(boolean isEditModusBar, boolean isDrawBar, boolean isEditBar, boolean isTextStyleBar, boolean isCommandBar) {
        this.remove(this.editModusBar);
        this.remove(this.drawBar);
        this.remove(this.editBar);
        this.remove(this.textStyleBar);
        this.remove(this.commandBar);
        if (isEditModusBar) {
            this.add((Component)this.editModusBar, "North");
        }
        if (isDrawBar) {
            this.add((Component)this.drawBar, "North");
        }
        if (isEditBar) {
            this.add((Component)this.editBar, "North");
        }
        if (isTextStyleBar) {
            this.add((Component)this.textStyleBar, "North");
        }
        if (isCommandBar) {
            this.add((Component)this.commandBar, "North");
        }
    }
}

