/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport;

import document.text.CursorShape;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.paintjobs.PaintJobDrawCursor;
import gui.components.pageviewport.paintjobs.PaintJobs;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Line2D;
import javax.swing.AbstractAction;
import javax.swing.Timer;
import util.math.MyMath;

public class CursorController
extends AbstractAction {
    private boolean enabled = false;
    private boolean isBlack = false;
    private int delay = 500;
    private Timer timer;
    boolean timerstop = false;
    float x1;
    float y1;
    float x2;
    float y2;
    float width;
    float lx1;
    float ly1;
    float lx2;
    float ly2;
    float lwidth;
    PageViewPortController controller;
    private boolean nextPaintBlack = false;
    private boolean dontRemove = false;
    private Rectangle repaintRect;

    public CursorController(PageViewPortController controller) {
        this.controller = controller;
        this.timer = new Timer(this.delay, this);
        this.timer.start();
    }

    public void timerStart() {
        this.timerstop = false;
    }

    public void timerStop() {
        this.timerstop = true;
    }

    public void setCursorPos(float x1, float y1, float x2, float y2, float width) {
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.width = 2.0f;
    }

    public void repaintImmediately() {
        this.nextPaintBlack = true;
        this.actionPerformed(null);
    }

    public void forceAddRepaintJobs() {
        this.nextPaintBlack = true;
        this.addJobsToQueue();
    }

    public void setNextPaintBlack() {
        this.nextPaintBlack = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobsToQueue() {
        this.repaintRect = null;
        PaintJobs paintJobs = this.controller.getPageViewport().getPaintJobs();
        synchronized (paintJobs) {
            if (this.enabled) {
                if (this.isBlack) {
                    this.clearOldCursor();
                    if (this.nextPaintBlack) {
                        this.drawNewCursor();
                        this.nextPaintBlack = false;
                    }
                } else {
                    this.drawNewCursor();
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.timerstop && this.enabled) {
            this.addJobsToQueue();
            this.controller.getPageViewport().repaint(this.repaintRect);
        }
    }

    private void drawNewCursor() {
        PaintJobDrawCursor job = new PaintJobDrawCursor(this.x1, this.y1, this.x2, this.y2, this.width, true);
        this.controller.getPageViewport().addJob(job);
        this.dontRemove = false;
        this.lx1 = this.x1;
        this.lx2 = this.x2;
        this.ly1 = this.y1;
        this.ly2 = this.y2;
        this.lwidth = this.width;
        this.isBlack = true;
        Rectangle rect = this.getRepaintRect(this.x1, this.x2, this.y1, this.y2, this.width);
        if (this.repaintRect == null) {
            this.repaintRect = rect;
        } else {
            this.repaintRect.add(rect);
        }
    }

    private Rectangle getRepaintRect(float x1, float x2, float y1, float y2, float width) {
        float xmin = MyMath.min(x1, x2);
        float ymin = MyMath.min(y1, y2);
        float xmax = MyMath.max(x1, x2);
        float ymax = MyMath.max(y1, y2);
        int wh = (int)width / 2;
        if (wh == 0) {
            wh = 1;
        }
        return new Rectangle((int)(xmin - (float)wh), (int)(ymin - (float)wh), (int)(xmax - xmin + (float)(2 * wh)), (int)(ymax - ymin + (float)(2 * wh)));
    }

    private void clearOldCursor() {
        if (!this.dontRemove) {
            PaintJobDrawCursor job = new PaintJobDrawCursor(this.lx1, this.ly1, this.lx2, this.ly2, this.lwidth, false);
            this.controller.getPageViewport().addJob(job);
            Rectangle rect = this.getRepaintRect(this.lx1, this.lx2, this.ly1, this.ly2, this.lwidth);
            if (this.repaintRect == null) {
                this.repaintRect = rect;
            } else {
                this.repaintRect.add(rect);
            }
        } else {
            this.dontRemove = false;
        }
        this.isBlack = false;
    }

    public void clearCursor(Graphics2D g2d) {
        if (PaintJobDrawCursor.isLastPaintBlack()) {
            g2d.setColor(Color.black);
            g2d.setXORMode(Color.white);
            g2d.setStroke(new BasicStroke(this.width));
            Line2D.Float line = new Line2D.Float(this.lx1, this.ly1, this.lx2, this.ly2);
            g2d.draw(line);
            g2d.setPaintMode();
            this.isBlack = false;
            PaintJobDrawCursor.setLastPaintBlack(false);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.dontRemove = true;
        if (b) {
            this.addJobsToQueue();
        }
    }

    public void addLastClearJobAndSetDisabled() {
        this.setEnabled(false);
        if (this.isBlack) {
            this.clearOldCursor();
            this.isBlack = false;
        }
    }

    public boolean isBlack() {
        return this.isBlack;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.timer.setDelay(delay);
    }

    public void setCursorPos(CursorShape cursorShape) {
        if (cursorShape != null) {
            this.setCursorPos(cursorShape.getX1(), cursorShape.getY1(), cursorShape.getX2(), cursorShape.getY2(), cursorShape.getWidth());
        } else {
            this.addLastClearJobAndSetDisabled();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void doRepaint() {
        if (this.repaintRect != null) {
            this.controller.getPageViewport().repaint(this.repaintRect);
        } else {
            this.controller.doRepaint();
        }
    }
}

