/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport;

import document.AbstractKeyboardFocusable;
import document.MyDocument;
import document.MyObject;
import document.MyPage;
import document.text.CursorShape;
import document.view.MyView;
import gui.components.pageviewport.CursorController;
import gui.components.pageviewport.PageController;
import gui.components.pageviewport.PageScrollPane;
import gui.components.pageviewport.PageScrollPaneController;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.autoarrange.SnapInfo;
import gui.components.pageviewport.autoarrange.SnapPositions;
import gui.components.pageviewport.graphiccontext.ViewportGraphicContext;
import gui.components.pageviewport.handles.HandleController;
import gui.components.pageviewport.paintjobs.PaintJobBeginChangeMarkedObjects;
import gui.components.pageviewport.paintjobs.PaintJobBeginMouseMove;
import gui.components.pageviewport.paintjobs.PaintJobLeftUpCallBack;
import gui.components.pageviewport.paintjobs.PaintJobMouseMoveUpdateDrawNew;
import gui.components.pageviewport.paintjobs.PaintJobPaintAll;
import gui.components.pageviewport.paintjobs.PaintJobPaintTextField;
import gui.components.pageviewport.ruler.Ruler;
import gui.components.pageviewport.ruler.RulerInfo;
import gui.components.pageviewport.states.AbstractState;
import gui.components.pageviewport.states.LeftUpCallBack;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.pageviewport.states.data.MouseDocumentInfo;
import gui.components.zoomfactor.ZoomFactor;
import gui.icons.ViewportIcon;
import init.Settings;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import util.math.MyMath;
import util.math.PointDouble;
import util.math.PointInt;
import util.math.RectangleDouble;

public class PageViewPortController {
    private PageViewport pageViewport;
    private CursorController cursorController;
    private MyView view = null;
    private PageScrollPaneController pageScrollPaneController;
    private AbstractState state;
    private MarkedObjectsAndHandles stateInfo = new MarkedObjectsAndHandles(this);
    private double visibleWidthcm;
    private double horizontalMargincm = 0.7;
    private double horizontalSpacecm = 0.7;
    private double verticalMargincm = 0.7;
    private double verticalSpacecm = 1.0;
    private int pagesPerRow;
    private double shadowThicknessCm = 0.16;
    private int firstVisiblePage;
    private int lastVisiblePage;
    private Hashtable<MyPage, PageController> pageControllers;
    private double visibleHeightcm;
    private int counter = 0;

    public PointDouble pixelToPageCm(PointInt pPanel, MyPage page) {
        PageController pc = this.getPageController(page);
        return this.pageViewport.pixelTocm(pPanel.sub(pc.getTopLeft()));
    }

    public void setMetrics() {
        double nVerticalMargincm;
        double nHorizontalMargincm;
        this.pageViewport.setScreenResolution();
        RulerInfo rulerInfo = new RulerInfo(this.pageViewport.getScreenResolutioncm() * this.pageViewport.getZoomFactor().getFactor());
        int visibleWidthPixel = this.pageScrollPaneController.getPageScrollPane().getViewport().getWidth() - 22;
        int visibleHeightPixel = this.pageScrollPaneController.getPageScrollPane().getViewport().getHeight() - 22;
        if (this.view.isAutomaticZoomToFitPage() && visibleWidthPixel > 0) {
            double visibleWidth100PerCentZoom = (double)visibleWidthPixel / this.pageViewport.getScreenResolutioncm();
            double visibleHeight100PerCentZoom = (double)visibleHeightPixel / this.pageViewport.getScreenResolutioncm();
            double zoomHor = visibleWidth100PerCentZoom / (this.view.getMaxPageWidth() + 0.1);
            double zoomVert = visibleHeight100PerCentZoom / (this.view.getMaxPageHeight() + 0.1);
            this.pageViewport.setZoomFactor(new ZoomFactor(MyMath.min(zoomHor, zoomVert)));
        }
        this.visibleWidthcm = this.pageViewport.pixelTocmX(this.pageScrollPaneController.getPageScrollPane().getViewport().getWidth());
        this.visibleHeightcm = this.pageViewport.pixelTocmY(this.pageScrollPaneController.getPageScrollPane().getViewport().getHeight());
        if (this.view.isDrawBorderAndShadow()) {
            nHorizontalMargincm = this.horizontalMargincm;
            nVerticalMargincm = this.verticalMargincm;
        } else {
            nHorizontalMargincm = this.pageViewport.getZoomFactor().getFactor() * (this.visibleWidthcm - this.view.getMaxPageWidth() - 0.05) / 2.0;
            if (nHorizontalMargincm < 0.0) {
                nHorizontalMargincm = 0.0;
            }
            if ((nVerticalMargincm = this.pageViewport.getZoomFactor().getFactor() * (this.visibleHeightcm - this.view.getMaxPageHeight() - 0.05) / 2.0) < 0.0) {
                nVerticalMargincm = 0.0;
            }
        }
        double maxPageWidth = this.view.getMaxPageWidth();
        double remainingWidth = this.visibleWidthcm - 2.0 * nHorizontalMargincm / this.pageViewport.getZoomFactor().getFactor() - maxPageWidth;
        this.pagesPerRow = (int)Math.floor(remainingWidth / (maxPageWidth + this.horizontalSpacecm / this.pageViewport.getZoomFactor().getFactor())) + 1;
        this.pageControllers = new Hashtable(this.view.pages.size());
        int left = this.pageViewport.screenCmToPixelX(nHorizontalMargincm);
        int top = this.pageViewport.screenCmToPixelY(nVerticalMargincm);
        int column = 1;
        int maxPageHeight = 0;
        int maxRowWidth = 0;
        for (MyPage page : this.view.pages) {
            PageController pc = new PageController(page, this);
            this.pageControllers.put(page, pc);
            pc.setLeftPixel(left);
            pc.setTopPixel(top);
            pc.setRightPixel(left + this.pageViewport.cmXtoPixel(page.getWidthcm()));
            pc.setBottomPixel(top + this.pageViewport.cmYtoPixel(page.getHeightcm()));
            rulerInfo.addPageRulerInfo(left, page.getWidthcm(), RulerInfo.Direction.horizontal);
            rulerInfo.addPageRulerInfo(top, page.getHeightcm(), RulerInfo.Direction.vertical);
            if (maxPageHeight < this.pageViewport.cmYtoPixel(page.getHeightcm())) {
                maxPageHeight = this.pageViewport.cmYtoPixel(page.getHeightcm());
            }
            if (column < this.pagesPerRow) {
                left = pc.getRightPixel() + this.pageViewport.screenCmToPixelX(this.horizontalSpacecm);
                ++column;
                continue;
            }
            if (maxRowWidth < left + this.pageViewport.cmXtoPixel(page.getWidthcm())) {
                maxRowWidth = left + this.pageViewport.cmXtoPixel(page.getWidthcm());
            }
            left = this.pageViewport.screenCmToPixelX(nHorizontalMargincm);
            top += maxPageHeight;
            top += this.pageViewport.screenCmToPixelY(this.verticalSpacecm);
            maxPageHeight = 0;
            column = 1;
        }
        top = column == 1 ? (top -= this.pageViewport.screenCmToPixelY(this.verticalSpacecm)) : (top += maxPageHeight);
        this.pageViewport.setSizeXY(maxRowWidth += this.pageViewport.screenCmToPixelX(nHorizontalMargincm), top += this.pageViewport.screenCmToPixelY(nVerticalMargincm));
        Ruler rulerHorizontal = new Ruler(rulerInfo, RulerInfo.Direction.horizontal, this);
        rulerHorizontal.setPreferredWidth(maxRowWidth);
        rulerHorizontal.addRulerMarkSource(this.view.getArtificialLines());
        rulerHorizontal.addRulerMarkSource(this.view.getBorders());
        Ruler rulerVertical = new Ruler(rulerInfo, RulerInfo.Direction.vertical, this);
        rulerVertical.setPreferredHeight(top);
        rulerVertical.addRulerMarkSource(this.view.getArtificialLines());
        rulerVertical.addRulerMarkSource(this.view.getBorders());
        PageScrollPane psp = this.pageScrollPaneController.getPageScrollPane();
        if (Settings.getInstance().getToggleEditModus() == Settings.ToggleEditModus.edit) {
            psp.setColumnHeaderView(rulerHorizontal);
            psp.setRowHeaderView(rulerVertical);
        } else {
            psp.setColumnHeaderView(null);
            psp.setRowHeaderView(null);
        }
        this.pageViewport.revalidate();
    }

    public double setZoomfactor(ZoomFactor zf) {
        double zoomFactor = 1.0;
        this.pageViewport.setScreenResolution();
        this.pageViewport.setZoomFactor(new ZoomFactor(1.0));
        this.visibleWidthcm = this.pageViewport.pixelTocmX(this.pageScrollPaneController.getPageScrollPane().getViewport().getWidth());
        this.visibleHeightcm = this.pageViewport.pixelTocmX(this.pageScrollPaneController.getPageScrollPane().getViewport().getHeight());
        MyPage page = null;
        page = this.stateInfo.getMarkedObjects().getPage() != null ? this.stateInfo.getMarkedObjects().getPage() : this.view.pages.get((this.lastVisiblePage - this.firstVisiblePage) / 2);
        if (!zf.isPageWidth() && !zf.isWholePage()) {
            zoomFactor = zf.getFactor();
        } else {
            double zoomfactorHor = this.visibleWidthcm / (page.getWidthcm() + 2.0);
            double zoomfactorVert = this.visibleHeightcm / (page.getHeightcm() + 2.0);
            zoomFactor = zf.isPageWidth() ? zoomfactorHor : MyMath.min(zoomfactorHor, zoomfactorVert);
        }
        if (zf.isPageWidth()) {
            zf.setPageWidth(zoomFactor);
        }
        if (zf.isWholePage()) {
            zf.setWholePage(zoomFactor);
        }
        this.pageViewport.setZoomFactor(zf);
        this.setMetrics();
        PageScrollPane scrollPane = this.pageScrollPaneController.getPageScrollPane();
        int OneCmInPixel = this.pageViewport.cmXtoPixel(1.0);
        if (zf.isPageWidth() || zf.isWholePage() || this.stateInfo.getMarkedObjects().getPage() == null) {
            PageController pc = this.getPageController(page);
            scrollPane.getViewport().setViewPosition(new Point(pc.getLeftPixel() - OneCmInPixel, pc.getTopPixel() - OneCmInPixel));
        } else {
            page = this.stateInfo.getMarkedObjects().getPage();
            int x = this.pageViewport.pageCmXtoPixel(this.stateInfo.getMarkedObjects().getBoundingBox().getLeft(), page) - OneCmInPixel;
            int y = this.pageViewport.pageCmYtoPixel(this.stateInfo.getMarkedObjects().getBoundingBox().getTop(), page) - OneCmInPixel;
            scrollPane.getViewport().setViewPosition(new Point(x, y));
        }
        this.stateInfo.getHandlesOfMarkedObjects();
        this.updateCursor(true);
        this.doRepaint();
        return zoomFactor;
    }

    public void scrollToShowPageRectangle(RectangleDouble rect, MyPage page) {
        PointDouble upperLeft = new PointDouble(rect.getLeft(), rect.getTop());
        PointDouble bottomRight = new PointDouble(rect.getRight(), rect.getBottom());
        upperLeft = this.getPageViewport().pageCmToPixel(upperLeft, page);
        bottomRight = this.getPageViewport().pageCmToPixel(bottomRight, page);
        Rectangle panelRect = new Rectangle((int)upperLeft.getX(), (int)upperLeft.getY(), (int)(bottomRight.getX() - upperLeft.getX()), (int)(bottomRight.getY() - upperLeft.getY()));
        this.scrollToShowPanelRectangle(panelRect);
    }

    public void scrollToShowPanelRectangle(Rectangle rect) {
        int newTop = 0;
        int newLeft = 0;
        int width = this.pageScrollPaneController.getPageScrollPane().getViewport().getWidth();
        int height = this.pageScrollPaneController.getPageScrollPane().getViewport().getHeight();
        Point topLeft = this.pageScrollPaneController.getPageScrollPane().getViewport().getViewPosition();
        if (!(rect.getX() >= (double)topLeft.x && rect.getY() >= (double)topLeft.y && rect.getX() + rect.getWidth() <= (double)(topLeft.x + width) && rect.getY() + rect.getHeight() <= (double)(topLeft.y + height))) {
            newLeft = rect.getWidth() < (double)width ? (int)rect.getX() - (int)(((double)width - rect.getWidth()) / 2.0) : (int)rect.getX() - 10;
            if (newLeft < 0) {
                newLeft = 0;
            }
            if (newLeft > this.pageViewport.getWidth() - width) {
                newLeft = this.pageViewport.getWidth() - width;
            }
            if ((newTop = rect.getHeight() < (double)height ? (int)rect.getY() - (int)(((double)height - rect.getHeight()) / 2.0) : (int)rect.getY() - 10) < 0) {
                newTop = 0;
            }
            if (newTop > this.pageViewport.getHeight() - height) {
                newTop = this.pageViewport.getHeight() - height;
            }
            this.pageScrollPaneController.getPageScrollPane().getViewport().setViewPosition(new Point(newLeft, newTop));
            this.addJobPaintActiveTextfield(false);
            this.addJobPaintAll();
            this.doRepaint();
        }
    }

    public PageViewPortController(PageScrollPaneController pageScrollPaneController) {
        this.pageScrollPaneController = pageScrollPaneController;
        this.pageViewport = new PageViewport(this);
        this.cursorController = new CursorController(this);
    }

    public PageViewport getPageViewport() {
        return this.pageViewport;
    }

    public MyDocument getDocument() {
        if (this.view != null) {
            return this.view.getDocument();
        }
        return null;
    }

    public void viewPortResized() {
        this.setMetrics();
        this.stateInfo.getHandlesOfMarkedObjects();
    }

    public boolean pageIsVisible(MyPage page) {
        PageController pc = this.getPageController(page);
        Rectangle visibleRectangle = this.pageScrollPaneController.getVisibleRectangle();
        int shadowThickness = this.pageViewport.screenCmToPixelX(this.shadowThicknessCm);
        Rectangle pageWithShadow = new Rectangle(pc.getLeftPixel(), pc.getTopPixel() - shadowThickness, pc.getWidth() + shadowThickness, pc.getHeight() + shadowThickness);
        return pageWithShadow.intersects(visibleRectangle);
    }

    public PageController getPageController(MyPage page) {
        if (page != null) {
            return this.pageControllers.get(page);
        }
        return null;
    }

    public MyPage pageUnderCursor(PointInt pPanel) {
        boolean pageFound = false;
        MyPage page = null;
        int i = this.firstVisiblePage;
        while (i <= this.lastVisiblePage && !pageFound) {
            page = this.view.pages.get(i);
            if (this.isInsidePage(pPanel, page)) {
                pageFound = true;
            }
            ++i;
        }
        if (!pageFound) {
            page = null;
        }
        return page;
    }

    public boolean isInsidePage(PointInt pPanel, MyPage page) {
        PageController pc = this.getPageController(page);
        return pPanel.isInRect(pc.getPageRectangle());
    }

    public MyObject objectUnderCursor(PointInt pPanel, MyPage page) {
        PointDouble pPage = this.pixelToPageCm(pPanel, page);
        double pickWidth = this.pageViewport.pixelTocmX(2);
        AbstractKeyboardFocusable kf = this.stateInfo.getKeyboardFocusableObject();
        if (kf != null && kf.getPage() == page && kf.isInTextArea(pPage, pickWidth)) {
            return kf;
        }
        return page.ObjectUnderCursor(pPage);
    }

    public void paintPageBackgroundShadow(MyPage page, Graphics2D g2d) {
        PageController pg = this.pageControllers.get(page);
        int thickness = this.pageViewport.screenCmToPixelX(this.shadowThicknessCm);
        this.pageViewport.paintPageBackground(pg, g2d);
        if (this.view.isDrawBorderAndShadow()) {
            this.pageViewport.paintShadow(pg, thickness, g2d);
        }
    }

    public void paintTabOrderArrows(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        int i = 0;
        while (i < this.view.pages.size()) {
            MyPage page = this.view.getPage(i);
            for (MyObject object : page.objects) {
                AbstractKeyboardFocusable akf;
                AbstractKeyboardFocusable destakf;
                if (!(object instanceof AbstractKeyboardFocusable) || (destakf = (akf = (AbstractKeyboardFocusable)object).getNextTabObject()) == null || !this.pageIsVisible(page) && !this.pageIsVisible(destakf.getPage())) continue;
                akf.drawFocusOrderArrow(g2d, this);
            }
            ++i;
        }
    }

    public void paintAllVisiblePages(Graphics2D g2d, boolean onlyBelowMarkedObjects, boolean paintCopyOfMarkedObjects) {
        MyPage pageWithMarkedObjects = this.stateInfo.getMarkedObjects().getPage();
        this.firstVisiblePage = 100000;
        this.lastVisiblePage = -1;
        int i = 0;
        while (i < this.view.pages.size()) {
            MyPage page = this.view.getPage(i);
            if (this.pageIsVisible(page)) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                this.paintPageBackgroundShadow(page, g2d);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                PageController pc = this.getPageController(page);
                Rectangle r = null;
                if (g2d.getClipBounds() == null) {
                    r = this.getPageScrollPaneController().getVisibleRectangle();
                    g2d.setClip(r.x, r.y, r.width, r.height);
                }
                ViewportGraphicContext vgc = this.pageViewport.getViewPortGraphicContext(page, g2d, r);
                if (Settings.getInstance().getToggleEditModus() == Settings.ToggleEditModus.edit) {
                    vgc.setPageCoordinates();
                    if (Settings.getInstance().isSnapToGrid()) {
                        this.view.getGrid().drawGridLines(vgc);
                    }
                    if (Settings.getInstance().isSnapToArtificialLines()) {
                        this.view.getArtificialLines().drawArtificialLines(vgc, false);
                        this.view.getBorders().drawBorderLines(vgc, false);
                    }
                    vgc.setPanelCoordinates();
                }
                if (onlyBelowMarkedObjects && page == pageWithMarkedObjects) {
                    pc.paint(g2d, true, paintCopyOfMarkedObjects);
                } else {
                    pc.paint(g2d, false, paintCopyOfMarkedObjects);
                }
                int index = this.view.indexOfPage(page);
                if (index < this.firstVisiblePage) {
                    this.firstVisiblePage = index;
                }
                if (index > this.lastVisiblePage) {
                    this.lastVisiblePage = index;
                }
            }
            ++i;
        }
    }

    public PageScrollPaneController getPageScrollPaneController() {
        return this.pageScrollPaneController;
    }

    public MarkedObjectsAndHandles getStateInfo() {
        return this.stateInfo;
    }

    public AbstractState getState() {
        return this.state;
    }

    public void stateChanged(AbstractState state) {
        this.state = state;
    }

    public void doRepaint() {
        this.pageViewport.repaint();
    }

    public void addJobMouseMoveUpdate() {
        this.pageViewport.addJob(PaintJobMouseMoveUpdateDrawNew.getInstance());
    }

    public void addLeftUpCallBack(MouseEvent e, MouseDocumentInfo info, LeftUpCallBack state) {
        PaintJobLeftUpCallBack job = new PaintJobLeftUpCallBack(e, info, state);
        this.pageViewport.addJob(job);
    }

    public void drawHandles(Graphics2D g2d) {
        this.stateInfo.drawHandles(g2d);
    }

    public void drawIcons(Graphics2D g2d) {
        Rectangle boundsRect = null;
        if (g2d.getClipBounds() == null) {
            boundsRect = this.getPageScrollPaneController().getVisibleRectangle();
            g2d.setClip(boundsRect.x, boundsRect.y, boundsRect.width, boundsRect.height);
        }
        int i = this.firstVisiblePage;
        while (i <= this.lastVisiblePage) {
            MyPage page = this.view.getPage(i);
            ViewportGraphicContext vgc = this.pageViewport.getViewPortGraphicContext(page, g2d, boundsRect);
            for (MyObject object : page.objects) {
                if (!object.hasIcons()) continue;
                ArrayList<ViewportIcon> icons = object.getIcons();
                for (ViewportIcon icon : icons) {
                    if (icon.getMouseState() == ViewportIcon.MouseState.invisible) continue;
                    icon.render(vgc, this);
                }
            }
            ++i;
        }
    }

    public void addJobBeginMouseMove() {
        this.pageViewport.addJob(PaintJobBeginMouseMove.getInstance());
    }

    public void addJobChangeMarkedObjects() {
        this.pageViewport.addJob(PaintJobBeginChangeMarkedObjects.getInstance());
    }

    public void addJobPaintAll() {
        this.pageViewport.addJob(PaintJobPaintAll.getInstance());
    }

    public void beginMouseMove() {
        this.pageViewport.beginMouseMove(true);
    }

    public HandleController handleUnderCursor(PointInt p) {
        HandleController handle = null;
        int i = 0;
        while (i < this.stateInfo.getHandles().size()) {
            if (this.stateInfo.getHandles().get(i).contains(p.getX(), p.getY())) {
                handle = this.stateInfo.getHandles().get(i);
                break;
            }
            ++i;
        }
        return handle;
    }

    public void snapToGridAndArtificialLines(PointDouble p, PointDouble positionToAlter, SnapInfo snapInfo) {
        if (Settings.getInstance().getToggleEditModus() == Settings.ToggleEditModus.edit) {
            if (Settings.getInstance().isSnapToGrid()) {
                this.view.getGrid().snap(p, positionToAlter);
                snapInfo.xCoordinateGotSnapped = true;
                snapInfo.yCoordinateGotSnapped = true;
            } else if (Settings.getInstance().isSnapToArtificialLines()) {
                this.view.getArtificialLines().snapAtArtificialLines(p, positionToAlter, snapInfo, this.getSnapDeltaCm());
                this.view.getBorders().snap(snapInfo, p, positionToAlter, this.getSnapDeltaCm());
            }
        }
    }

    public SnapPositions getSnapPositions(MyPage page) {
        PageController pc = this.getPageController(page);
        return pc.getSnapPositions();
    }

    public void drawActiveSnapPositions(Graphics2D g2d) {
        int i = this.firstVisiblePage;
        while (i <= this.lastVisiblePage) {
            MyPage page = this.view.pages.get(i);
            PageController pc = this.pageControllers.get(page);
            ViewportGraphicContext vgc = this.pageViewport.getViewPortGraphicContext(page, g2d, null);
            vgc.setPageCoordinates(true);
            if (Settings.getInstance().isSnapToArtificialLines()) {
                this.view.getArtificialLines().drawArtificialLines(vgc, true);
                this.view.getBorders().drawBorderLines(vgc, true);
            }
            if (pc.getSnapPositions().hasActiveSnapPositions() && Settings.getInstance().isSnapToObjects()) {
                pc.drawActiveSnapPositions(g2d);
            }
            vgc.setPanelCoordinates();
            ++i;
        }
    }

    public double getSnapDeltaCm() {
        return this.pageViewport.pixelTocmX(2);
    }

    public void clearAllSnapPositions() {
        for (MyPage page : this.view.pages) {
            this.getPageController(page).clearSnapPositions();
        }
    }

    public CursorController getCursorController() {
        return this.cursorController;
    }

    public void updateCursor(boolean scrollToGetCursorVisible) {
        AbstractKeyboardFocusable kf = this.getStateInfo().getKeyboardFocusableObject();
        if (kf != null) {
            CursorShape cs = kf.getCursorShape();
            if (cs != null) {
                this.setCursorShapeToPanelCoordinates(cs, kf);
                this.cursorController.setCursorPos(cs);
                if (scrollToGetCursorVisible) {
                    int x = (int)cs.getX1();
                    if (cs.getX2() < (float)x) {
                        x = (int)cs.getX2();
                    }
                    int y = (int)cs.getY1();
                    if (cs.getY2() < (float)y) {
                        y = (int)cs.getY2();
                    }
                    this.scrollToShowPanelRectangle(new Rectangle(x, y, (int)cs.getRectWidth(), (int)cs.getRectHeight()));
                }
            } else {
                this.cursorController.addLastClearJobAndSetDisabled();
            }
        }
    }

    private void setCursorShapeToPanelCoordinates(CursorShape cs, AbstractKeyboardFocusable kf) {
        if (cs != null) {
            MyPage page = kf.getPage();
            float x1 = this.pageViewport.pageCmXtoPixel(cs.getX1(), page);
            float x2 = this.pageViewport.pageCmXtoPixel(cs.getX2(), page);
            float y1 = this.pageViewport.pageCmYtoPixel(cs.getY1(), page);
            float y2 = this.pageViewport.pageCmYtoPixel(cs.getY2(), page);
            if (x1 == x2) {
                cs.setCoordinates(x1, y1 - 1.0f, x2, y2 + 1.0f);
            } else if (y1 == y2) {
                cs.setCoordinates(x1 - 1.0f, y1, x2 + 1.0f, y2);
            } else {
                cs.setCoordinates(x1, y1, x2, y2);
            }
        }
    }

    public void addJobPaintTextfield(AbstractKeyboardFocusable object, boolean onlyPaintDirtyRegions) {
        PaintJobPaintTextField job = new PaintJobPaintTextField(object, this, true, onlyPaintDirtyRegions, false);
        this.pageViewport.addJob(job);
    }

    public void addJobPaintActiveTextfield(boolean onlyPaintDirtyRegions) {
        AbstractKeyboardFocusable kf = this.getStateInfo().getKeyboardFocusableObject();
        if (kf != null) {
            this.addJobPaintTextfield(kf, onlyPaintDirtyRegions);
            if (Math.abs(kf.getAngle()) > 1.0E-6 || !onlyPaintDirtyRegions) {
                this.doRepaint();
            } else {
                Rectangle2D realsizeRect = kf.getRealSizeRectangle();
                double width = realsizeRect.getWidth();
                double height = realsizeRect.getHeight();
                double midX = realsizeRect.getX() + width / 2.0;
                double midY = realsizeRect.getY() + height / 2.0;
                this.pageViewport.repaint(this.getPanelRect(midX, midY, height / 2.0, height / 2.0, width / 2.0, width / 2.0, 0.0, kf.getPage()));
            }
        }
    }

    public int getFirstVisiblePage() {
        return this.firstVisiblePage;
    }

    public int getLastVisiblePage() {
        return this.lastVisiblePage;
    }

    public MyView getView() {
        return this.view;
    }

    public void setView(MyView view) {
        this.view = view;
        this.setMetrics();
    }

    public void setAllArtificialAndBorderLinesToInactive() {
        this.view.getArtificialLines().setAllArtificialLinesInactive();
        this.view.getBorders().setAllBorderLinesInactive();
    }

    public Rectangle getPanelRect(MyObject o) {
        Rectangle2D rsr = o.getRealSizeRectangle();
        double extraheight = rsr.getHeight() - o.getHeight();
        return this.getPanelRect(o.getMidX(), o.getMidY(), o.getHeight() / 2.0, o.getHeight() / 2.0 + extraheight, o.getWidth() / 2.0, o.getWidth() / 2.0, o.getAngle(), o.getPage());
    }

    public Rectangle getPanelRect(double midX, double midY, double topHalf, double bottomHalf, double leftHalf, double rightHalf, double angle, MyPage page) {
        PointDouble mid = new PointDouble(midX, midY);
        mid = this.pageViewport.pageCmToPixel(mid, page);
        midX = mid.x;
        midY = mid.y;
        leftHalf = this.pageViewport.cmXtoPixel(leftHalf);
        rightHalf = this.pageViewport.cmXtoPixel(rightHalf);
        topHalf = this.pageViewport.cmYtoPixel(topHalf);
        bottomHalf = this.pageViewport.cmYtoPixel(bottomHalf);
        PointDouble p = new PointDouble(midX - leftHalf, midY - topHalf);
        MyMath.rotate(p, midX, midY, angle);
        double xmin = p.x;
        double xmax = p.x;
        double ymin = p.y;
        double ymax = p.y;
        p.x = midX + rightHalf;
        p.y = midY - topHalf;
        MyMath.rotate(p, midX, midY, angle);
        if (xmin > p.x) {
            xmin = p.x;
        }
        if (xmax < p.x) {
            xmax = p.x;
        }
        if (ymin > p.y) {
            ymin = p.y;
        }
        if (ymax < p.y) {
            ymax = p.y;
        }
        p.x = midX - leftHalf;
        p.y = midY + bottomHalf;
        MyMath.rotate(p, midX, midY, angle);
        if (xmin > p.x) {
            xmin = p.x;
        }
        if (xmax < p.x) {
            xmax = p.x;
        }
        if (ymin > p.y) {
            ymin = p.y;
        }
        if (ymax < p.y) {
            ymax = p.y;
        }
        p.x = midX + rightHalf;
        p.y = midY + bottomHalf;
        MyMath.rotate(p, midX, midY, angle);
        if (xmin > p.x) {
            xmin = p.x;
        }
        if (xmax < p.x) {
            xmax = p.x;
        }
        if (ymin > p.y) {
            ymin = p.y;
        }
        if (ymax < p.y) {
            ymax = p.y;
        }
        return new Rectangle((int)xmin, (int)ymin, (int)(xmax - xmin), (int)(ymax - ymin));
    }
}

