/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.handles;

import document.MyObject;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.handles.HandleGui;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import util.math.PointDouble;

public abstract class HandleController {
    HandleGui handle;
    PointDouble startPoint;
    MyObject originalObject;
    protected PageViewPortController pageViewPortController;
    boolean isHighlighted = false;

    public boolean contains(int x, int y) {
        return this.handle.contains(x, y);
    }

    public void startPulling(PointDouble startPoint) {
        this.startPoint = startPoint.getCopy();
        this.originalObject.makePreview();
    }

    public void cancelPulling() {
        this.originalObject.releasePreview();
    }

    public void pull(PointDouble mousePosition, boolean shiftPressed, boolean ctrlPressed, MarkedObjectsAndHandles stateInfo) {
        this.transformByPulling(mousePosition, shiftPressed, ctrlPressed, false, stateInfo);
    }

    public void endPulling(PointDouble mousePosition, boolean shiftPressed, boolean ctrlPressed, MarkedObjectsAndHandles stateInfo) {
        this.transformByPulling(mousePosition, shiftPressed, ctrlPressed, true, stateInfo);
        this.originalObject.releasePreview();
    }

    public abstract void transformByPulling(PointDouble var1, boolean var2, boolean var3, boolean var4, MarkedObjectsAndHandles var5);

    public void setHighlightState(boolean highlighted) {
        if (highlighted != this.isHighlighted) {
            this.isHighlighted = highlighted;
        }
    }

    public void mouseMove(int x, int y) {
        if (this.contains(x, y)) {
            this.setHighlightState(true);
        } else {
            this.setHighlightState(false);
        }
    }

    public void setPositionAngle(float midX, float midY, double angle) {
        this.handle.translateRotate(midX, midY, angle);
    }

    public void draw(Graphics2D g2d) {
        this.handle.draw(g2d, this.isHighlighted);
    }

    public MyObject getOriginalObject() {
        return this.originalObject;
    }

    public void renewSnapPositions(MyObject excludedObject) {
        this.pageViewPortController.getPageController(this.originalObject.getPage()).renewSnapPositions(excludedObject);
    }

    public Rectangle getBounds() {
        return this.handle.getBounds();
    }
}

