/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.handles;

import commands.RotateCommand;
import document.MyObject;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.handles.HandleController;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.handles.CircleArrowHandle;
import util.math.MyMath;
import util.math.PointDouble;

public class RotateHandleController
extends HandleController {
    public RotateHandleController(MyObject originalObject, float midX, float midY, double angle, PageViewport pageViewPort) {
        this.originalObject = originalObject;
        this.handle = new CircleArrowHandle();
        this.setPositionAngle(midX, midY, angle);
        this.pageViewPortController = pageViewPort.getController();
    }

    @Override
    public void transformByPulling(PointDouble mousePosition, boolean shiftPressed, boolean ctrlPressed, boolean transformOriginal, MarkedObjectsAndHandles stateInfo) {
        PointDouble center = new PointDouble(this.originalObject.getMidX(), this.originalObject.getMidY());
        double angle = MyMath.angle(this.startPoint, center, mousePosition);
        if (shiftPressed) {
            double angleStep = 0.2617993877991494;
            angle = angleStep * (double)Math.round(angle / angleStep);
        }
        if (transformOriginal) {
            RotateCommand command = new RotateCommand(stateInfo, this.originalObject, center, angle);
        } else {
            this.originalObject.copyToPreviewObject();
            MyObject objectToTransform = this.originalObject.getPreviewObject();
            objectToTransform.rotate(center, angle);
        }
    }
}

