/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.states;

import document.MyObject;
import document.MyPage;
import gui.actions.MyAction;
import gui.components.pageviewport.PageController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.autoarrange.SnapInfo;
import gui.components.pageviewport.autoarrange.SnapPositions;
import gui.components.pageviewport.states.AbstractState;
import gui.components.pageviewport.states.StateIdle;
import gui.components.pageviewport.states.StateLeftDownDrawingLine;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.pageviewport.states.data.MouseDocumentInfo;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import util.math.PointDouble;

public class StateIdleBeforeDrawingLine
extends AbstractState {
    private PageViewPortController controller;
    private static StateIdleBeforeDrawingLine instance;
    private PointDouble pos;
    private MyObject object;
    private MyAction action;

    private StateIdleBeforeDrawingLine(PageViewPortController controller) {
        this.controller = controller;
    }

    public static AbstractState enter(PageViewPortController controller, MyObject object, MyAction action) {
        if (instance == null) {
            instance = new StateIdleBeforeDrawingLine(controller);
        }
        StateIdleBeforeDrawingLine.instance.object = object;
        StateIdleBeforeDrawingLine.instance.action = action;
        StateIdleBeforeDrawingLine.instance.controller = controller;
        MarkedObjectsAndHandles stateInfo = controller.getStateInfo();
        stateInfo.clearMarkedObjects();
        controller.getCursorController().setEnabled(false);
        stateInfo.setKeyboardFocusableObject(null);
        controller.getPageViewport().setCursor(Cursor.getPredefinedCursor(1));
        return instance;
    }

    @Override
    public void ESCpressed() {
        this.action.setSelected(false);
        this.controller.stateChanged(StateIdle.enter(this.controller));
    }

    @Override
    public void keyboardpressed(KeyEvent e) {
    }

    @Override
    public void mouseLeftDown(MouseEvent e, MouseDocumentInfo info) {
        if (info.getPage() != null) {
            this.object.setPage(info.getPage());
            info.getMarkedObjectsAndHandles().setObjectToDraw(this.object);
            this.controller.stateChanged(StateLeftDownDrawingLine.enter(this.controller, this.pos, this.object, this.action));
        } else {
            this.ESCpressed();
        }
    }

    @Override
    public void mouseLeftUp(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseRightDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseRightUp(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseMoved(MouseEvent e, MouseDocumentInfo info) {
        this.pos = new PointDouble(info.getXCm(), info.getYCm());
        MyPage page = info.getPage();
        if (page != null) {
            this.controller.setAllArtificialAndBorderLinesToInactive();
            SnapInfo snapInfo = new SnapInfo();
            this.controller.snapToGridAndArtificialLines(this.pos, this.pos, snapInfo);
            PointDouble posAfterArtificialLineGridSnap = this.pos.getCopy();
            PageController pc = this.controller.getPageController(page);
            SnapPositions snapPositions = pc.getSnapPositions();
            snapPositions.clearActivePositions();
            if (snapPositions.isEmpty()) {
                pc.renewSnapPositions(null);
            }
            double maxDistance = this.controller.getSnapDeltaCm();
            snapPositions.snapPoint(this.pos, this.pos, SnapPositions.Type.horizontal, maxDistance);
            snapPositions.snapPoint(this.pos, this.pos, SnapPositions.Type.vertical, maxDistance);
            if (snapInfo.xCoordinateGotSnapped) {
                this.pos.x = posAfterArtificialLineGridSnap.x;
            }
            if (snapInfo.yCoordinateGotSnapped) {
                this.pos.y = posAfterArtificialLineGridSnap.y;
            }
            this.controller.getStateInfo().getMarkedObjects().setPage(page);
            this.controller.addJobMouseMoveUpdate();
            this.controller.doRepaint();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

