/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.states;

import document.MyObject;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.AbstractState;
import gui.components.pageviewport.states.StateIdle;
import gui.components.pageviewport.states.StateMoveObject;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.pageviewport.states.data.MouseDocumentInfo;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import util.math.PointDouble;

public class StateLeftDownOnObject
extends AbstractState {
    private PageViewPortController controller;
    private static StateLeftDownOnObject instance;
    private PointDouble positionButtonPressed;
    private MyObject object;

    private StateLeftDownOnObject(PageViewPortController controller) {
        this.controller = controller;
    }

    public static AbstractState enter(PageViewPortController controller, PointDouble positionButtonPressed, MyObject object) {
        if (instance == null) {
            instance = new StateLeftDownOnObject(controller);
        }
        StateLeftDownOnObject.instance.controller = controller;
        StateLeftDownOnObject.instance.object = object;
        StateLeftDownOnObject.instance.positionButtonPressed = positionButtonPressed;
        return instance;
    }

    @Override
    public void ESCpressed() {
        this.controller.stateChanged(StateIdle.enter(this.controller));
    }

    @Override
    public void keyboardpressed(KeyEvent e) {
    }

    @Override
    public void mouseLeftDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseLeftUp(MouseEvent e, MouseDocumentInfo info) {
        if (info.getObject() != null) {
            MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
            if (!e.isShiftDown()) {
                stateInfo.clearMarkedObjects();
            }
            if (stateInfo.isMarked(info.getObject())) {
                stateInfo.unMarkObject(info.getObject());
            } else {
                stateInfo.addMarkedObject(info.getObject());
            }
            stateInfo.getHandlesOfMarkedObjects();
            this.controller.doRepaint();
        }
        this.controller.stateChanged(StateIdle.enter(this.controller));
    }

    @Override
    public void mouseMoved(MouseEvent e, MouseDocumentInfo info) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        if (this.object != null) {
            if (!stateInfo.isMarked(this.object)) {
                stateInfo.clearMarkedObjects();
                stateInfo.addMarkedObject(this.object);
            }
            stateInfo.getMarkedObjects().makePreview();
            this.controller.beginMouseMove();
            this.controller.stateChanged(StateMoveObject.enter(this.controller, this.positionButtonPressed));
        } else {
            this.ESCpressed();
        }
    }

    @Override
    public void mouseRightDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseRightUp(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

