/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.states.data;

import document.AbstractKeyboardFocusable;
import document.MyObject;
import document.MyPage;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.handles.HandleController;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import util.math.PointDouble;
import util.math.PointInt;

public class MouseDocumentInfo {
    private PointInt pPanel;
    MyPage page = null;
    private PointDouble pPage;
    private MyObject object = null;
    private HandleController handle;
    private PageViewPortController controller;
    private double cmPerPixel = 0.0;

    public MouseDocumentInfo(PageViewPortController controller, double cmPerPixel) {
        this.controller = controller;
        this.cmPerPixel = cmPerPixel;
    }

    public MyObject getObject() {
        return this.object;
    }

    public void setObject(MyObject object) {
        this.object = object;
    }

    public MyPage getPage() {
        return this.page;
    }

    public void setPage(MyPage page) {
        this.page = page;
    }

    public int getX() {
        return this.pPanel.getX();
    }

    public double getXCm() {
        return this.pPage.getX();
    }

    public int getY() {
        return this.pPanel.getY();
    }

    public double getYCm() {
        return this.pPage.getY();
    }

    public void setPanelPoint(PointInt pPanel) {
        this.pPanel = pPanel.getCopy();
    }

    public void setPagePoint(PointDouble pPage) {
        this.pPage = pPage.getCopy();
    }

    public PointInt getPPanel() {
        return this.pPanel;
    }

    public void setHandle(HandleController handle) {
        this.handle = handle;
    }

    public PointDouble getPPage() {
        return this.pPage;
    }

    public void setPPage(PointDouble page) {
        this.pPage = page;
    }

    public HandleController getHandle() {
        return this.handle;
    }

    public void setPPanel(PointInt panel) {
        this.pPanel = panel;
    }

    public PageViewPortController getController() {
        return this.controller;
    }

    public MarkedObjectsAndHandles getMarkedObjectsAndHandles() {
        return this.controller.getStateInfo();
    }

    public AbstractKeyboardFocusable getKeyboardFocusableIfInsideText() {
        if (this.object instanceof AbstractKeyboardFocusable) {
            AbstractKeyboardFocusable kf = (AbstractKeyboardFocusable)this.object;
            if (kf.isInTextArea(this.pPage, this.cmPerPixel * (double)AbstractKeyboardFocusable.getPickWidthPixel())) {
                return kf;
            }
            return null;
        }
        return null;
    }
}

