/*
 * Decompiled with CFR 0.152.
 */
package gui.components.toolbars.colorchooser;

import gui.components.toolbars.colorchooser.ColorChooserListener;
import gui.components.toolbars.colorchooser.ColorChooserPopup;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import util.io.IO;

public class ColorChooserToolButton
implements ActionListener {
    private JButton mainButton;
    private ImageIcon mainIcon;
    private Rectangle colorRectangle;
    private Color color = Color.red;
    private boolean withoutColor = false;
    private JButton chooseButton;
    private ColorChooserPopup colorChooserPopup;
    private ColorChooserListener colorChooserListener;

    public ColorChooserToolButton(String pathToMainIcon, Rectangle colorRectangle, ColorChooserListener colorChooserListener, String withoutColorText) {
        this.colorRectangle = colorRectangle;
        this.colorChooserListener = colorChooserListener;
        this.mainIcon = IO.loadImage(pathToMainIcon);
        this.mainButton = new JButton();
        this.setMainIconImage();
        this.chooseButton = new JButton(IO.loadImage("/data/img/menu/16/triangle.png"));
        this.chooseButton.setSize(8, this.mainButton.getHeight());
        this.mainButton.setFocusable(false);
        this.chooseButton.setFocusable(false);
        this.chooseButton.addActionListener(this);
        this.chooseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getXOnScreen() != 0) {
                    ColorChooserToolButton.this.mainButton.dispatchEvent(new MouseEvent(ColorChooserToolButton.this.mainButton, 504, e.getWhen(), e.getModifiers(), 1, 1, 0, 0, 0, false, 0));
                }
                super.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.getXOnScreen() != 0) {
                    ColorChooserToolButton.this.mainButton.dispatchEvent(new MouseEvent(ColorChooserToolButton.this.mainButton, 505, e.getWhen(), e.getModifiers(), 1, 1, 0, 0, 0, false, 0));
                }
                super.mouseExited(e);
            }
        });
        this.mainButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getXOnScreen() != 0) {
                    ColorChooserToolButton.this.chooseButton.dispatchEvent(new MouseEvent(ColorChooserToolButton.this.chooseButton, 504, e.getWhen(), e.getModifiers(), 1, 1, 0, 0, 0, false, 0));
                }
                super.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.getXOnScreen() != 0) {
                    ColorChooserToolButton.this.chooseButton.dispatchEvent(new MouseEvent(ColorChooserToolButton.this.chooseButton, 505, e.getWhen(), e.getModifiers(), 1, 1, 0, 0, 0, false, 0));
                }
                super.mouseExited(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ColorChooserToolButton.this.withoutColor) {
                    ColorChooserToolButton.this.withoutColorPicked();
                } else {
                    ColorChooserToolButton.this.pickColor(ColorChooserToolButton.this.color);
                }
                super.mouseClicked(e);
            }
        });
        this.colorChooserPopup = new ColorChooserPopup(colorChooserListener, withoutColorText);
    }

    public void setMainIconImage() {
        BufferedImage image = new BufferedImage(this.mainIcon.getIconWidth(), this.mainIcon.getIconHeight(), 2);
        Graphics g = image.getGraphics();
        g.drawImage(this.mainIcon.getImage(), 0, 0, null);
        if (this.withoutColor) {
            g.setColor(Color.gray);
            g.drawRect(this.colorRectangle.x, this.colorRectangle.y, this.colorRectangle.width, this.colorRectangle.height);
            g.setColor(Color.white);
            g.drawRect(this.colorRectangle.x + 1, this.colorRectangle.y + 1, this.colorRectangle.width - 2, this.colorRectangle.height - 2);
        } else {
            g.setColor(this.color);
            g.fillRect(this.colorRectangle.x, this.colorRectangle.y, this.colorRectangle.width, this.colorRectangle.height);
        }
        this.mainButton.setIcon(new ImageIcon(image));
    }

    public JButton getChooseButton() {
        return this.chooseButton;
    }

    public JButton getMainButton() {
        return this.mainButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.chooseButton) {
            int x = 0;
            int y = this.chooseButton.getHeight();
            this.colorChooserPopup.show(this.chooseButton, x, y);
        }
    }

    protected void installAncestorListener() {
        this.chooseButton.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ColorChooserToolButton.this.hidePopup();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                ColorChooserToolButton.this.hidePopup();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                if (event.getSource() != ColorChooserToolButton.this.chooseButton) {
                    ColorChooserToolButton.this.hidePopup();
                }
            }
        });
    }

    public void hidePopup() {
        this.colorChooserPopup.setVisible(false);
    }

    public void setMainButtonColor(Color c, boolean withoutColor) {
        this.withoutColor = withoutColor;
        this.color = c;
        this.setMainIconImage();
    }

    public void pickColor(Color c) {
        this.colorChooserListener.colorPicked(c);
    }

    public void withoutColorPicked() {
        this.colorChooserListener.withoutColorPicked();
    }

    public boolean isWithoutColor() {
        return this.withoutColor;
    }

    public void setEnabled(boolean isEnabled) {
        this.chooseButton.setEnabled(isEnabled);
        this.mainButton.setEnabled(isEnabled);
    }
}

