/*
 * Decompiled with CFR 0.152.
 */
package gui.components.toolbars.linewidthchooser;

import gui.components.toolbars.linewidthchooser.LinewidthChooserPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.LineMetrics;
import javax.swing.JPanel;

public class LinewidthButton
extends JPanel
implements MouseListener {
    private static int borderWidth = 4;
    private static int buttonHeight = 26;
    private static int exampleWidth = 30;
    private static int textWidth = 50;
    private float linewidth;
    private LinewidthChooserPanel panel;
    private boolean isMouseOver = false;
    private boolean isMousePressed = false;
    private static float dpi = Toolkit.getDefaultToolkit().getScreenResolution();
    private static Font font = new Font("Arial", 0, 10);

    public LinewidthButton(float linewidth, LinewidthChooserPanel panel) {
        int width = 2 * borderWidth + textWidth + exampleWidth;
        this.setPreferredSize(new Dimension(width, buttonHeight));
        this.setMaximumSize(new Dimension(width, buttonHeight));
        this.linewidth = linewidth;
        this.panel = panel;
        this.addMouseListener(this);
        this.setFocusable(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isMouseOver = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isMouseOver = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.isMousePressed = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isMousePressed = false;
        if (this.isMouseOver) {
            this.panel.linewidthButtonPressed(this.linewidth);
            this.isMouseOver = false;
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isMouseOver || this.isMousePressed) {
            if (this.isMousePressed) {
                g.setColor(new Color(176, 176, 255));
            } else {
                g.setColor(Color.white);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 2);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.black);
        g2d.setFont(font);
        LineMetrics lm = font.getLineMetrics("Tg", g2d.getFontRenderContext());
        float ypos = (float)(buttonHeight / 2) + lm.getAscent() / 2.0f - lm.getDescent() / 2.0f;
        g2d.drawString(this.getLinewidthString(this.linewidth), (float)borderWidth, ypos);
        double ppc = (double)dpi / 2.54;
        g2d.setStroke(new BasicStroke((float)((double)this.linewidth * ppc)));
        g2d.drawLine(borderWidth + textWidth, buttonHeight / 2, borderWidth + textWidth + exampleWidth, buttonHeight / 2);
    }

    private String getLinewidthString(double linewidth) {
        Double x = new Double(linewidth *= 10.0);
        String s = String.format("%1.1f", x);
        s = String.valueOf(s) + " mm";
        return s;
    }

    public void setLinewidth(float linewidth) {
        this.linewidth = linewidth;
        this.repaint();
    }
}

