/*
 * Decompiled with CFR 0.152.
 */
package gui.components.toolbars.linewidthchooser;

import gui.components.toolbars.linewidthchooser.LinewidthButton;
import gui.components.toolbars.linewidthchooser.LinewidthChooserListener;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import util.language.Lang;
import util.language.LanguageComponent;

public class LinewidthChooserPanel
extends JPanel
implements LanguageComponent {
    private static float[] fixedLinewidths = new float[]{0.01f, 0.03f, 0.05f, 0.1f, 0.15f, 0.2f, 0.3f, 0.5f};
    private LinewidthButton[] fixedLinewidthButtons = new LinewidthButton[fixedLinewidths.length];
    private JPanel fixedLinewidthsPanel;
    private int maxLastUsedLinewidths = 3;
    private LinewidthButton[] lastUsedLinewidths = new LinewidthButton[this.maxLastUsedLinewidths];
    private boolean[] isUsed = new boolean[this.maxLastUsedLinewidths];
    private JPanel lastUsedLinewidthsPanel;
    private int nextFreeUsedLinewidth = 0;
    private LinewidthChooserListener linewidthChooserListener;

    public LinewidthChooserPanel(LinewidthChooserListener linewidthChooserListener) {
        Lang.registerComponent(this);
        this.linewidthChooserListener = linewidthChooserListener;
        this.languageChanged();
        int i = 0;
        while (i < this.isUsed.length) {
            this.isUsed[i] = false;
            ++i;
        }
        i = 0;
        while (i < this.lastUsedLinewidths.length) {
            this.lastUsedLinewidths[i] = new LinewidthButton(0.0f, this);
            ++i;
        }
        this.makePanels();
        this.makeLastUsedColorsPanel();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.fixedLinewidthsPanel);
    }

    private void makeLastUsedColorsPanel() {
        int count = 0;
        int i = 0;
        while (i < this.isUsed.length) {
            if (!this.isUsed[i]) break;
            count = i + 1;
            ++i;
        }
        this.lastUsedLinewidthsPanel.removeAll();
        this.lastUsedLinewidthsPanel.setLayout(new BoxLayout(this.lastUsedLinewidthsPanel, 1));
        i = 0;
        while (i < count) {
            this.lastUsedLinewidthsPanel.add(this.lastUsedLinewidths[i]);
            ++i;
        }
    }

    private void makePanels() {
        this.lastUsedLinewidthsPanel = new JPanel();
        this.fixedLinewidthsPanel = new JPanel(new GridLayout(fixedLinewidths.length, 1, 0, 1));
        int i = 0;
        while (i < fixedLinewidths.length) {
            this.fixedLinewidthButtons[i] = new LinewidthButton(fixedLinewidths[i], this);
            this.fixedLinewidthsPanel.add(this.fixedLinewidthButtons[i]);
            ++i;
        }
    }

    @Override
    public void languageChanged() {
    }

    public void addLastUsedLinewidth(float linewidth) {
        this.isUsed[this.nextFreeUsedLinewidth] = true;
        this.lastUsedLinewidths[this.nextFreeUsedLinewidth].setLinewidth(linewidth);
        ++this.nextFreeUsedLinewidth;
        if (this.nextFreeUsedLinewidth == this.maxLastUsedLinewidths) {
            this.nextFreeUsedLinewidth = 0;
        }
        this.makeLastUsedColorsPanel();
    }

    public void moreLinewidthsButtonPressed() {
    }

    public void linewidthButtonPressed(float linewidth) {
        this.linewidthChooserListener.chooseLinewidth(linewidth);
    }
}

