/*
 * Decompiled with CFR 0.152.
 */
package gui.components.zoomfactor;

import gui.components.zoomfactor.ZoomfactorComboBox;
import util.language.Lang;

public class ZoomFactor {
    private static double[] zoomFactors = new double[]{0.25, 0.5, 0.73, 1.0, 2.0, 4.0, -1.0, -1.0};
    private static String[] germanZoomFactors = new String[]{"25%", "50%", "73%", "100%", "200%", "400%", "Ganze Seite", "Seitenbreite"};
    int index;
    double factor;

    public ZoomFactor(int index) {
        this.index = index;
        this.factor = zoomFactors[index];
    }

    public ZoomFactor(double factor) {
        this.index = zoomFactors.length - 1;
        int i = 0;
        while (i < zoomFactors.length) {
            if (Math.abs(zoomFactors[i] - factor) < 1.0E-6) {
                this.index = i;
            }
            ++i;
        }
        this.factor = factor;
    }

    public int getIndex() {
        return this.index;
    }

    public void setWholePage(double factor) {
        this.index = zoomFactors.length - 2;
        this.factor = factor;
    }

    public void setPageWidth(double factor) {
        this.index = zoomFactors.length - 1;
        this.factor = factor;
    }

    public String getString() {
        return Lang.get(germanZoomFactors[this.index]);
    }

    public double getFactor() {
        return this.factor;
    }

    public boolean isWholePage() {
        return this.index == zoomFactors.length - 2;
    }

    public boolean isPageWidth() {
        return this.index == zoomFactors.length - 1;
    }

    public static void fillZoomfactorCombobox(ZoomfactorComboBox zoomfactorComboBox) {
        zoomfactorComboBox.removeAllItems();
        int i = 0;
        while (i < zoomFactors.length) {
            zoomfactorComboBox.addItem(Lang.get(germanZoomFactors[i]));
            ++i;
        }
    }
}

