/*
 * Decompiled with CFR 0.152.
 */
package renderer.g2dRenderer;

import document.MyObject;
import document.MyPage;
import document.Renderable;
import gui.components.pageviewport.graphiccontext.GraphicContext;

public class G2dRenderer {
    public GraphicContext gc;

    public G2dRenderer(GraphicContext gc) {
        this.gc = gc;
    }

    public void render(Renderable object, boolean isPreview) {
        switch (object.getType()) {
            case document: {
                break;
            }
            case page: {
                this.renderPage((MyPage)object);
                break;
            }
            default: {
                ((MyObject)object).render(this.gc, isPreview);
            }
        }
    }

    private void renderPage(MyPage page) {
        for (MyObject object : page.objects) {
            object.render(this.gc, false);
        }
    }

    public void renderBelowObject(MyPage page, boolean paintCopyOfMarkedObjects) {
        int indexTopMost = -1;
        int i = page.objects.size() - 1;
        while (i >= 0) {
            if (page.objects.get(i).hasPreview()) {
                indexTopMost = i;
                break;
            }
            --i;
        }
        i = 0;
        while (i <= indexTopMost) {
            if (!page.objects.get(i).hasPreview() || paintCopyOfMarkedObjects) {
                page.objects.get(i).render(this.gc, false);
            }
            ++i;
        }
    }

    public void renderAboveObject(MyPage page) {
        int indexTopMost = -1;
        int i = page.objects.size() - 1;
        while (i >= 0) {
            if (page.objects.get(i).hasPreview()) {
                indexTopMost = i;
                break;
            }
            --i;
        }
        i = indexTopMost + 1;
        while (i < page.objects.size()) {
            page.objects.get(i).render(this.gc, false);
            ++i;
        }
    }

    public void renderPreviewObjects(MyPage page) {
        int i = 0;
        while (i < page.objects.size()) {
            if (page.objects.get(i).hasPreview()) {
                page.objects.get(i).getPreviewObject().render(this.gc, true);
            }
            ++i;
        }
    }

    public void renderPreviewObject(MyObject object) {
        object.render(this.gc, true);
    }
}

