/*
 * Decompiled with CFR 0.152.
 */
package test;

import document.text.hyphenation.Hyphenation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class TestHyphenator {
    public static void main(String[] args) {
        boolean write = false;
        try {
            InputStreamReader reader = new InputStreamReader(new FileInputStream(new File("./build/trenndatei/Trenn.dat")));
            OutputStreamWriter writer = null;
            if (write) {
                writer = new OutputStreamWriter(new FileOutputStream(new File("./data/hyphenation/complicated_words.txt")));
            }
            int count = 1;
            int gesamt = 0;
            try {
                int c;
                while ((c = ((Reader)reader).read()) != -1) {
                    String word = "";
                    int i = 0;
                    while (i < 30) {
                        c = ((Reader)reader).read();
                        if ((char)c != ' ') {
                            word = String.valueOf(word) + (char)c;
                        }
                        ++i;
                    }
                    if (word.compareTo("langsam") == 0) {
                        word = "langsam";
                    }
                    String hyphenatedWord = "";
                    i = 0;
                    while (i < 35) {
                        c = ((Reader)reader).read();
                        if ((char)c != ' ') {
                            hyphenatedWord = String.valueOf(hyphenatedWord) + (char)c;
                        }
                        ++i;
                    }
                    String automaticWord = Hyphenation.getInstance().getSpelledWord(word);
                    if (hyphenatedWord.compareTo(automaticWord) != 0) {
                        System.out.println(count + ": " + word + "; " + hyphenatedWord + "; " + automaticWord);
                        if (write) {
                            TestHyphenator.write(writer, word, hyphenatedWord);
                        }
                        ++count;
                    }
                    ++gesamt;
                }
                System.out.println("Gesamt: " + gesamt);
                if (write) {
                    writer.write(".");
                }
            }
            finally {
                if (reader != null) {
                    ((Reader)reader).close();
                }
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private static void write(Writer writer, String word, String hyphenatedWord) throws IOException {
        int[] positions = TestHyphenator.getHyphenPositions(word, hyphenatedWord);
        writer.write(String.valueOf(word) + ";");
        int i = 0;
        while (i < positions.length) {
            writer.write((char)(97 + positions[i]));
            ++i;
        }
        writer.write(".");
    }

    private static int[] getHyphenPositions(String word, String hyphenatedWord) {
        int[] positions = new int[1000];
        int pw = 0;
        int phw = 0;
        int size = 0;
        while (pw < word.length() && phw < hyphenatedWord.length()) {
            if (word.charAt(pw) != '-' && hyphenatedWord.charAt(phw) == '-') {
                positions[size++] = pw;
                ++phw;
            }
            ++pw;
            ++phw;
        }
        int[] ret = new int[size];
        int i = 0;
        while (i < ret.length) {
            ret[i] = positions[i];
            ++i;
        }
        return ret;
    }
}

