/*
 * Decompiled with CFR 0.152.
 */
package test.textbausteine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import test.textbausteine.BausteinAlt;
import test.textbausteine.BausteinBereichAlt;
import test.textbausteine.BausteinNeu;

public class BemerkungsParser {
    private ArrayList<BausteinAlt> bausteineAlt = new ArrayList();
    private ArrayList<BausteinBereichAlt> bausteinBereicheAlt = new ArrayList();
    private ArrayList<BausteinNeu> bausteineNeu = new ArrayList();

    public void parse(String oldFilename, String newFilename) {
        boolean write = true;
        try {
            InputStreamReader reader = new InputStreamReader(new FileInputStream(new File(oldFilename)));
            OutputStreamWriter writer = null;
            if (write) {
                writer = new OutputStreamWriter(new FileOutputStream(new File(newFilename)));
            }
            String oldField = "@@";
            int num = 0;
            try {
                int c;
                System.out.print("Lese alte Bausteine ");
                while ((c = ((Reader)reader).read()) != -1) {
                    String line = "";
                    int i = 0;
                    while (i < 652) {
                        c = ((Reader)reader).read();
                        line = String.valueOf(line) + (char)c;
                        ++i;
                    }
                    String field = this.removeEndSpaces(line.substring(6, 12));
                    if (field.substring(0, oldField.length()).compareTo(oldField) != 0) {
                        BausteinBereichAlt bra = new BausteinBereichAlt();
                        bra.setField(field);
                        bra.setRemark(this.removeEndSpaces(line.substring(12)));
                        this.bausteinBereicheAlt.add(bra);
                        oldField = field;
                        continue;
                    }
                    BausteinAlt ba = new BausteinAlt();
                    ba.setField(field.substring(0, oldField.length()));
                    ba.setLevel(field.substring(oldField.length(), field.length()));
                    ba.setNumber(Integer.parseInt(this.removeEndSpaces(line.substring(0, 6))));
                    ba.setMaennlichPers(this.removeEndSpaces(line.substring(12, 172)));
                    ba.setWeiblichPers(this.removeEndSpaces(line.substring(172, 332)));
                    ba.setMaennlichUnpers(this.removeEndSpaces(line.substring(332, 492)));
                    ba.setWeiblichUnpers(this.removeEndSpaces(line.substring(492, 652)));
                    this.bausteineAlt.add(ba);
                    if (++num % 100 != 0) continue;
                    System.out.print(".");
                }
                System.out.println(" ");
                System.out.println("Konvertiere die Bausteine ...");
                for (BausteinAlt ba : this.bausteineAlt) {
                    BausteinNeu bn = ba.getBausteinNeu();
                    if (bn == null) continue;
                    this.bausteineNeu.add(bn);
                }
                System.out.println("Finde \u00e4hnliche Bausteine (1. Durchgang) ...");
                int i = 0;
                while (i < this.bausteineNeu.size()) {
                    this.condenseBausteineNeu(i);
                    ++i;
                }
                System.out.println("Finde \u00e4hnliche Bausteine (2. Durchgang) ...");
                i = 0;
                while (i < this.bausteineNeu.size()) {
                    this.condenseBausteineNeu(i);
                    ++i;
                }
                System.out.println("Schreibe die neuen Bausteine ...");
                if (write) {
                    for (BausteinBereichAlt ba : this.bausteinBereicheAlt) {
                        writer.write("ak ??=...:" + ba.getField() + ": " + ba.getRemark() + "\n");
                    }
                    for (BausteinNeu bn : this.bausteineNeu) {
                        bn.write(writer);
                    }
                }
            }
            finally {
                if (reader != null) {
                    ((Reader)reader).close();
                }
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    private void condenseBausteineNeu(int i) {
        int from = i;
        int to = i;
        boolean similarFound = true;
        int differentWordIndex = -1;
        while (to + 1 < this.bausteineNeu.size() && similarFound) {
            BausteinNeu bnfrom = this.bausteineNeu.get(from);
            BausteinNeu bnto = this.bausteineNeu.get(to + 1);
            ArrayList<String> tokensfrom = bnfrom.getTokens(bnfrom.getBausteinMitPlatzhaltern());
            ArrayList<String> tokensto = bnto.getTokens(bnto.getBausteinMitPlatzhaltern());
            if (tokensfrom.size() == tokensto.size()) {
                int j = 0;
                while (j < tokensfrom.size()) {
                    if (tokensfrom.get(j).compareTo(tokensto.get(j)) != 0 && j != differentWordIndex) {
                        if (differentWordIndex == -1) {
                            differentWordIndex = j;
                        } else {
                            similarFound = false;
                        }
                    }
                    ++j;
                }
            } else {
                similarFound = false;
            }
            if (!similarFound) continue;
            ++to;
        }
        if (to > from && differentWordIndex != -1) {
            String choice = "[[";
            int j = from;
            while (j <= to) {
                BausteinNeu bn = this.bausteineNeu.get(j);
                choice = String.valueOf(choice) + bn.getTokens(bn.getBausteinMitPlatzhaltern()).get(differentWordIndex);
                if (j < to) {
                    choice = String.valueOf(choice) + "|";
                }
                ++j;
            }
            choice = String.valueOf(choice) + "]]";
            this.bausteineNeu.get(from).replaceToken(differentWordIndex, choice);
            j = from + 1;
            while (j <= to) {
                this.bausteineNeu.remove(from + 1);
                ++j;
            }
        }
    }

    private String removeEndSpaces(String s) {
        int endIndex = s.length();
        while (endIndex > 0 && s.charAt(endIndex - 1) == ' ') {
            --endIndex;
        }
        return s.substring(0, endIndex);
    }
}

