/*
 * Decompiled with CFR 0.152.
 */
package util.graphics;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import util.io.IO;

public class CustomCursors {
    private ArrayList<Cursor> cursors = new ArrayList();
    public static int CURSOR_LEFT_RIGHT = 0;
    public static int CURSOR_UP_DOWN = 1;
    public static int CURSOR_X = 2;
    private String path = "data/img/cursors/";
    private String[] names = new String[]{"cursor_left_right", "cursor_up_down", "cursor_x"};
    private String[] filenames = new String[]{"cursor_left_right.png", "cursor_up_down.png", "cursor_x.png"};
    private int[] hotspot_x = new int[]{10, 9, 6};
    private int[] hotspot_y = new int[]{10, 10, 5};
    private static CustomCursors instance;

    public CustomCursors() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension bestSize = toolkit.getBestCursorSize(0, 0);
        int i = 0;
        while (i < this.filenames.length) {
            String filename = String.valueOf(this.path) + this.filenames[i];
            Image image = IO.loadImage(filename).getImage();
            BufferedImage bi = new BufferedImage(bestSize.width, bestSize.height, 2);
            Graphics g = bi.getGraphics();
            g.setColor(new Color(0, 0, 0, 0));
            g.fillRect(0, 0, bi.getWidth(), bi.getHeight());
            g.drawImage(image, 0, 0, null);
            Point hotspot = new Point(this.hotspot_x[i], this.hotspot_y[i]);
            this.cursors.add(toolkit.createCustomCursor(bi, hotspot, this.names[i]));
            ++i;
        }
    }

    public static Cursor getCursor(int index) {
        return CustomCursors.getInstance().cursors.get(index);
    }

    public static CustomCursors getInstance() {
        if (instance == null) {
            instance = new CustomCursors();
        }
        return instance;
    }
}

