/*
 * Decompiled with CFR 0.152.
 */
package util.graphics;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;

public class MyGraphics {
    public static final double tabArrowStartEndOffset = 10.0;

    public static void drawArrow(double x1, double y1, double x2, double y2, double arrowWidth, double startEndOffset, Graphics2D g2d) {
        double dy;
        double dx;
        double vx = y2 - y1;
        double vy = x1 - x2;
        double l = Math.sqrt(vx * vx + vy * vy);
        if (Math.abs(l) > 1.0E-6) {
            vx /= l;
            vy /= l;
        }
        if ((l = Math.sqrt((dx = x1 - x2) * dx + (dy = y1 - y2) * dy)) > 1.0E-6) {
            dx /= l;
            dy /= l;
        }
        x1 -= dx * startEndOffset;
        y1 -= dy * startEndOffset;
        x2 += dx * startEndOffset;
        y2 += dy * startEndOffset;
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        Line2D.Double line1 = new Line2D.Double(x2, y2, x2 + vx * arrowWidth + (dx *= 1.5 * arrowWidth), y2 + vy * arrowWidth + (dy *= 1.5 * arrowWidth));
        Line2D.Double line2 = new Line2D.Double(x2, y2, x2 - vx * arrowWidth + dx, y2 - vy * arrowWidth + dy);
        g2d.draw(line);
        g2d.draw(line1);
        g2d.draw(line2);
    }
}

