/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import util.io.IOInterface;
import util.string.MyString;

public class AppletIO
implements IOInterface {
    private ArrayList<String> dataFiles;

    public AppletIO() {
        try {
            String line;
            this.dataFiles = new ArrayList();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.openDataFile(".filelist")));
            while ((line = reader.readLine()) != null) {
                this.dataFiles.add(line);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, ex.toString());
            System.exit(0);
        }
    }

    @Override
    public ArrayList<String> listDirectory(String path) {
        if (path.charAt(path.length() - 1) != '/') {
            path = String.valueOf(path) + "/";
        }
        ArrayList<String> files = new ArrayList<String>();
        for (String s : this.dataFiles) {
            String file;
            int backslashPos;
            if (!s.startsWith(path, 0) || (backslashPos = (file = s.substring(path.length(), s.length())).indexOf(47)) <= -1 || MyString.contains(files, file = file.substring(0, backslashPos))) continue;
            files.add(file);
        }
        return files;
    }

    AppletIO(ArrayList<String> dataFiles) {
        this.dataFiles = dataFiles;
    }

    @Override
    public boolean existsDataFile(String filepath) {
        for (String dataFile : this.dataFiles) {
            if (!dataFile.equals(filepath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean existsDataDirectory(String directory) {
        if (!directory.endsWith("/")) {
            directory = String.valueOf(directory) + "/";
        }
        for (String dataFile : this.dataFiles) {
            if (!dataFile.startsWith(directory)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStream openDataFile(String filepath) throws IOException {
        URL url;
        if (filepath.length() == 0) {
            throw new IOException("Empty filepath is not allowed!");
        }
        if (filepath.charAt(0) != '/') {
            filepath = String.valueOf('/') + filepath;
        }
        if ((url = this.getClass().getResource(filepath)) == null) {
            throw new IOException("\"" + filepath + "\" not found!");
        }
        return url.openStream();
    }

    @Override
    public URL getDataFileURL(String filepath) throws IOException {
        URL url;
        if (filepath.length() == 0) {
            throw new IOException("Empty filepath is not allowed!");
        }
        if (filepath.charAt(0) != '/') {
            filepath = String.valueOf('/') + filepath;
        }
        if ((url = this.getClass().getResource(filepath)) == null) {
            throw new IOException("\"" + filepath + "\" not found!");
        }
        return url;
    }

    @Override
    public String[] listDataFiles(String directory) throws IOException {
        return this.listDataFiles(directory, null);
    }

    @Override
    public String[] listDataFiles(String directory, FilenameFilter filter) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        if (!directory.endsWith("/")) {
            directory = String.valueOf(directory) + "/";
        }
        for (String dataFile : this.dataFiles) {
            if (dataFile.length() <= directory.length() || !dataFile.startsWith(directory) || dataFile.substring(directory.length()).indexOf(47) != -1) continue;
            File file = new File(dataFile);
            if (filter != null && !filter.accept(file.getParentFile(), file.getName())) continue;
            ret.add(file.getName());
        }
        String[] list = new String[ret.size()];
        int i = 0;
        while (i < ret.size()) {
            list[i] = (String)ret.get(i);
            ++i;
        }
        return list;
    }
}

