/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileExtensionFilter
extends FileFilter {
    private String[] extensions;
    private String description;

    public FileExtensionFilter(String[] extensions, String description) {
        this.extensions = extensions;
        this.description = description;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = FileExtensionFilter.getExtension(f);
        if (extension != null) {
            int i = 0;
            while (i < this.extensions.length) {
                if (this.extensions[i].compareToIgnoreCase(extension) == 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

