/*
 * Decompiled with CFR 0.152.
 */
package util.logging;

import init.App;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import util.logging.LogInterface;

public class ApplicationLog
implements LogInterface {
    public static final String FILENAME_DEFAULT = "data/app.log";
    private static String logFileName;
    private static File logFile;
    private static PrintStream writer;
    private static int logLevel;

    static {
        logFile = null;
        writer = null;
        logLevel = 6;
    }

    public ApplicationLog(String logFileName) {
        try {
            ApplicationLog.logFileName = logFileName;
            logFile = new File(logFileName);
            if (logFile.exists()) {
                logFile.delete();
            }
            logFile.createNewFile();
            writer = new PrintStream(new FileOutputStream(logFile));
            writer.print(String.valueOf(ApplicationLog.time()) + " " + this.getLevelString(2) + " Logging started for: " + App.PROJECT_NAME_VERSION + "\n");
            writer.print(String.valueOf(ApplicationLog.time()) + " " + this.getLevelString(2) + " Operating system: " + System.getProperty("os.name") + ", " + System.getProperty("os.version") + "\n");
            writer.print(String.valueOf(ApplicationLog.time()) + " " + this.getLevelString(2) + " Java version: " + System.getProperty("java.version") + "\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public void log(int level, Object sender, String msg) {
        if (logLevel <= level) {
            if (sender == null) {
                sender = new Object();
            }
            writer.print(String.valueOf(ApplicationLog.time()) + " " + this.getLevelString(level) + " " + sender.getClass().getName() + ": " + msg + "\n");
            writer.flush();
        }
    }

    @Override
    public void log(int level, String msg) {
        if (logLevel <= level) {
            writer.print(String.valueOf(ApplicationLog.time()) + " " + this.getLevelString(level) + " " + msg + "\n");
        }
        writer.flush();
    }

    @Override
    public void log(Object sender, Exception e) {
        this.log(4, sender, e);
    }

    @Override
    public void log(Exception e) {
        this.log(4, null, e);
    }

    @Override
    public void log(int level, Object sender, Exception e) {
        if (sender == null) {
            sender = new Object();
        }
        writer.print(String.valueOf(ApplicationLog.time()) + " " + this.getLevelString(level) + " " + sender.getClass().getName() + " threw an exception: " + e.getMessage() + "\nStack Trace:\n");
        e.printStackTrace(writer);
        writer.flush();
        writer.print("\n");
    }

    @Override
    public void setLoggingLevel(int Level2) {
        logLevel = Level2;
    }

    @Override
    public void close() {
        writer.print(String.valueOf(ApplicationLog.time()) + " " + this.getLevelString(2) + " Logging closed." + "\n");
        writer.flush();
        writer.close();
    }

    private static String time() {
        DateFormat df = DateFormat.getTimeInstance(2);
        String s = null;
        s = df.format(new Date());
        return s;
    }

    private String getLevelString(int level) {
        if (level == 2) {
            return "       ";
        }
        if (level == 3) {
            return "WARNING";
        }
        if (level == 4) {
            return "ERROR  ";
        }
        if (level == 1) {
            return "DEBUG  ";
        }
        if (level == 5) {
            return "COMMAND";
        }
        return "???    ";
    }

    @Override
    public String getLogFilename() {
        return logFileName;
    }
}

