/*
 * Decompiled with CFR 0.152.
 */
package util.math;

import util.math.PointDouble;

public final class MyMath {
    public static final double EPSILON = 1.0E-6;

    public static void rotate(PointDouble p, double midX, double midY, double angle) {
        double x = p.getX();
        double y = p.getY();
        double sin = -Math.sin(angle);
        double cos = Math.cos(angle);
        double xnew = (x -= midX) * cos - (y -= midY) * sin;
        double ynew = y * cos + x * sin;
        p.setLocation(xnew + midX, ynew + midY);
    }

    public static double degToRad(double deg) {
        return deg * Math.PI / 180.0;
    }

    public static double radToDeg(double rad) {
        return 180.0 * rad / Math.PI;
    }

    public static double min(double a, double b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static double max(double a, double b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static double angle(PointDouble p1, PointDouble s, PointDouble p2) {
        PointDouble v1 = p1.getCopy();
        v1.sub(s);
        PointDouble v2 = p2.getCopy();
        v2.sub(s);
        double v1SkalarV2 = v1.getX() * v2.getX() + v1.getY() * v2.getY();
        double angle = Math.acos(v1SkalarV2 / (v1.abs() * v2.abs()));
        double crossProductZ = -v1.getX() * v2.getY() + v1.getY() * v2.getX();
        if (crossProductZ < 0.0) {
            angle = Math.PI * 2 - angle;
        }
        return angle;
    }

    public static double normalizeAngle(double angle) {
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        return angle;
    }

    public static double random(double from, double to) {
        return Math.random() * (to - from) + from;
    }

    public static int randomInt(int from, int to) {
        return (int)(Math.random() * (double)(to - from + 1) + (double)from);
    }

    public static float min(float a, float b) {
        if (a > b) {
            return b;
        }
        return a;
    }

    public static float max(float a, float b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static boolean isZero(double d) {
        return Math.abs(d) < 1.0E-6;
    }
}

