/*
 * Decompiled with CFR 0.152.
 */
package util.math;

import java.awt.geom.Point2D;
import util.math.PointInt;

public class PointDouble
extends Point2D.Double {
    private static final long serialVersionUID = 1L;

    public PointDouble() {
    }

    public PointDouble(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public PointDouble getCopy() {
        PointDouble p = new PointDouble(this.x, this.y);
        return p;
    }

    public void add(PointDouble p) {
        this.x += p.x;
        this.y += p.y;
    }

    public void sub(PointDouble p) {
        this.x -= p.x;
        this.y -= p.y;
    }

    public double abs() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double distanceTo(PointDouble p) {
        return Math.sqrt((this.x - p.x) * (this.x - p.x) + (this.y - p.y) * (this.y - p.y));
    }

    @Override
    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public PointDouble mult(double factor) {
        return new PointDouble(this.x * factor, this.y * factor);
    }

    public PointInt round() {
        return new PointInt((int)Math.round(this.x), (int)Math.round(this.y));
    }

    @Override
    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void stretch(PointDouble center, double factor) {
        this.x = (this.x - center.x) * factor + center.x;
        this.y = (this.y - center.y) * factor + center.y;
    }
}

