/*
 * Decompiled with CFR 0.152.
 */
package util.math;

import java.awt.Rectangle;
import util.math.PointDouble;

public class PointInt {
    private int x = 0;
    private int y = 0;

    public PointInt() {
    }

    public PointInt(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public PointInt getCopy() {
        PointInt p = new PointInt(this.x, this.y);
        return p;
    }

    public PointInt add(PointInt p) {
        return new PointInt(this.x + p.x, this.y + p.y);
    }

    public PointInt sub(PointInt p) {
        return new PointInt(this.x - p.x, this.y - p.y);
    }

    public double abs() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double distanceTo(PointInt p) {
        return Math.sqrt((this.x - p.x) * (this.x - p.x) + (this.y - p.y) * (this.y - p.y));
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public PointDouble toPointDouble() {
        return new PointDouble(this.x, this.y);
    }

    public PointDouble mult(double factor) {
        return new PointDouble((double)this.x * factor, (double)this.y * factor);
    }

    public PointInt mult(int factor) {
        return new PointInt(this.x * factor, this.y * factor);
    }

    public boolean isInRect(Rectangle r) {
        return this.x >= r.x && this.x <= r.x + r.width - 1 && this.y >= r.y && this.y <= r.y + r.height - 1;
    }
}

