/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.baseclasses.AbstractCommand;
import document.MyDocument;
import document.MyPage;
import document.view.MyView;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import javax.swing.JOptionPane;
import util.language.Lang;

public class NewPageCommand
extends AbstractCommand {
    private MyPage page;
    private int pageIndex;
    private PageViewPortController controller;

    public NewPageCommand(PageViewPortController controller, boolean afterLastVisible, int indexToInsert) {
        this.controller = controller;
        MyView view = controller.getView();
        if (view.isAutomaticZoomToFitPage()) {
            JOptionPane.showMessageDialog(controller.getPageScrollPaneController().getPageScrollPane(), Lang.get("In der Schnelleingabe kann es nur eine Seite geben."));
        } else {
            MyDocument document = controller.getDocument();
            if (afterLastVisible) {
                int lastVisiblePageIndex = controller.getLastVisiblePage();
                MyPage lastVisiblePage = view.getPage(lastVisiblePageIndex);
                if (lastVisiblePage != null) {
                    this.page = new MyPage(lastVisiblePage.getWidthcm(), lastVisiblePage.getHeightcm());
                    this.pageIndex = lastVisiblePageIndex + 1;
                } else {
                    this.page = new MyPage();
                    this.pageIndex = 0;
                }
            } else {
                this.page = new MyPage();
                this.pageIndex = indexToInsert;
            }
            document.getCommandManager().invokeCommand(this);
        }
    }

    @Override
    public final boolean doIt() {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        this.controller.getView().addPage(this.page, this.pageIndex);
        this.controller.setMetrics();
        stateInfo.clearHandles();
        stateInfo.getHandlesOfMarkedObjects();
        this.controller.doRepaint();
        return true;
    }

    @Override
    public final boolean undoIt() {
        this.controller.getView().removePage(this.page);
        this.controller.setMetrics();
        this.controller.doRepaint();
        return false;
    }
}

