/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.baseclasses.AbstractCommand;
import document.MyDocument;
import document.view.MyView;
import gui.components.pageviewport.PageViewPortController;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import javax.swing.JOptionPane;
import util.language.Lang;

public class RemoveQuickviewCommand
extends AbstractCommand {
    private MyDocument document;
    private MyView quickView;
    int index;
    int tabIndex;

    public RemoveQuickviewCommand(MyDocument document) {
        DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
        PageViewPortController controller = dTPC.getActivePageScrollPaneController().getPageViewPortController();
        this.document = document;
        if (document.getQuickView() != null) {
            this.quickView = document.getQuickView();
            this.index = dTPC.getIndexOfView(this.quickView);
            this.tabIndex = dTPC.getTabIndexOfView(this.quickView);
            document.getCommandManager().invokeCommand(this);
        } else {
            JOptionPane.showMessageDialog(controller.getPageScrollPaneController().getPageScrollPane(), Lang.get("Das aktive Dokument hat keine Schnelleingabeansicht."));
        }
    }

    @Override
    public final boolean doIt() {
        DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
        this.document.getViews().remove(this.quickView);
        dTPC.removeView(this.quickView);
        dTPC.getTabbedPane().repaint();
        return true;
    }

    @Override
    public final boolean undoIt() {
        DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
        this.document.getViews().add(this.quickView);
        dTPC.insertView(this.quickView, this.index, this.tabIndex);
        dTPC.getTabbedPane().repaint();
        return false;
    }
}

