/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.baseclasses.MarkedObjectsPreserveCommand;
import document.MyObject;
import document.Renderable;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import util.math.PointDouble;

public class StretchCommand
extends MarkedObjectsPreserveCommand {
    private MyObject object;
    private double factor;
    private PointDouble center;
    private MarkedObjectsAndHandles stateInfo;

    public StretchCommand(MarkedObjectsAndHandles stateInfo, MyObject objectToStretch, PointDouble center, double factor) {
        this.factor = factor;
        this.object = objectToStretch;
        this.center = center.getCopy();
        this.stateInfo = stateInfo;
        if (this.object.getType() == Renderable.ObjectType.markedObjects) {
            this.saveMarkedObjects(stateInfo);
        }
        objectToStretch.getDocument().getCommandManager().invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        if (this.object.getType() == Renderable.ObjectType.markedObjects) {
            this.restoreMarkedObjects(this.stateInfo);
        }
        this.object.stretch(this.center, this.factor);
        return Math.abs(this.factor) > 1.0E-6;
    }

    @Override
    public final boolean undoIt() {
        if (this.object.getType() == Renderable.ObjectType.markedObjects) {
            this.restoreMarkedObjects(this.stateInfo);
        }
        this.object.stretch(this.center, 1.0 / this.factor);
        return false;
    }
}

