/*
 * Decompiled with CFR 0.152.
 */
package commands.changemarkfield;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.TextStyleChangeable;
import document.text.TextStyle;
import document.text.TextStyleFactory;

public class SetFontSizeCommand
extends AbstractCommand {
    private int oldfontSize;
    private int newfontSize;
    private TextStyleChangeable textStyleChangeable;

    public SetFontSizeCommand(int newfontSize, TextStyleChangeable textStyleChangeable, CommandManager commandManager) {
        this.textStyleChangeable = textStyleChangeable;
        this.newfontSize = newfontSize;
        this.oldfontSize = textStyleChangeable.getTextStyle().getSize();
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        TextStyle ots = this.textStyleChangeable.getTextStyle();
        TextStyle newTextStyle = TextStyleFactory.getInstance().getTextStyle(ots.getFontName(), this.newfontSize, ots.getFontColor(), ots.isUnderlined(), ots.isBold(), ots.isItalic());
        this.textStyleChangeable.setTextStyle(newTextStyle);
        return true;
    }

    @Override
    public final boolean undoIt() {
        TextStyle ots = this.textStyleChangeable.getTextStyle();
        TextStyle newTextStyle = TextStyleFactory.getInstance().getTextStyle(ots.getFontName(), this.oldfontSize, ots.getFontColor(), ots.isUnderlined(), ots.isBold(), ots.isItalic());
        this.textStyleChangeable.setTextStyle(newTextStyle);
        return false;
    }
}

