/*
 * Decompiled with CFR 0.152.
 */
package commands.changetext;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.text.AttributedText;
import document.text.TextFieldController;
import document.text.chunks.Chunk;
import document.text.textstylechanger.BoldChanger;
import java.util.ArrayList;

public class ChangeTextStyleBoldCommand
extends AbstractCommand {
    private int from;
    private int to;
    private boolean bold;
    private ArrayList<Chunk> oldChunks = null;
    private TextFieldController controller;

    public ChangeTextStyleBoldCommand(int pfrom, int pto, boolean pbold, TextFieldController pcontroller, CommandManager commandManager) {
        this.from = pfrom;
        this.to = pto;
        this.bold = pbold;
        this.controller = pcontroller;
        if (this.from > this.to) {
            int z = this.from;
            this.from = this.to;
            this.to = z;
        }
        this.controller = pcontroller;
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        BoldChanger textStyleChanger = new BoldChanger(this.bold);
        this.oldChunks = attributedText.changeTextStyle(this.from, this.to, textStyleChanger);
        return true;
    }

    @Override
    public final boolean undoIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        attributedText.undoFormatChange(this.oldChunks, this.from, this.to);
        return false;
    }
}

