/*
 * Decompiled with CFR 0.152.
 */
package commands.changetext;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.text.AttributedText;
import document.text.TextFieldController;
import document.text.chunks.Chunk;
import document.text.textstylechanger.FontSizeChanger;
import java.util.ArrayList;

public class ChangeTextStyleFontSizeCommand
extends AbstractCommand {
    private int from;
    private int to;
    private int fontSize;
    private ArrayList<Chunk> oldChunks = null;
    private TextFieldController controller;

    public ChangeTextStyleFontSizeCommand(int from, int to, int fontSize, TextFieldController controller, CommandManager commandManager) {
        this.from = from;
        this.to = to;
        this.fontSize = fontSize;
        this.controller = controller;
        if (from > to) {
            int z = this.from;
            this.from = to;
            this.to = z;
        }
        this.controller = controller;
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        FontSizeChanger textStyleChanger = new FontSizeChanger(this.fontSize);
        this.oldChunks = attributedText.changeTextStyle(this.from, this.to, textStyleChanger);
        return true;
    }

    @Override
    public final boolean undoIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        attributedText.undoFormatChange(this.oldChunks, this.from, this.to);
        return false;
    }
}

