/*
 * Decompiled with CFR 0.152.
 */
package commands.changetext;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.text.AttributedText;
import document.text.TextFieldController;
import document.text.chunks.Chunk;
import java.util.ArrayList;
import util.clipboard.ClipboardHelper;

public class CopyToClipboard
extends AbstractCommand {
    private int textToCopyBegin;
    private int textToCopyEnd;
    private ArrayList<Chunk> textToClear = null;
    private int cursorBefore;
    private int cursorAfter;
    private TextFieldController controller;
    boolean deleteWithCopy;

    public CopyToClipboard(int cursorBefore, int textToCopyBegin, int textToCopyEnd, boolean deleteWithCopy, TextFieldController controller, CommandManager commandManager) {
        this.cursorBefore = cursorBefore;
        this.textToCopyBegin = textToCopyBegin;
        this.textToCopyEnd = textToCopyEnd;
        this.deleteWithCopy = deleteWithCopy;
        if (this.textToCopyBegin > this.textToCopyEnd) {
            int z = this.textToCopyBegin;
            this.textToCopyBegin = this.textToCopyEnd;
            this.textToCopyEnd = z;
        }
        this.cursorAfter = this.textToCopyBegin != this.textToCopyEnd && deleteWithCopy ? this.textToCopyBegin : cursorBefore;
        this.controller = controller;
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        if (this.textToCopyBegin != this.textToCopyEnd) {
            this.textToClear = attributedText.deleteCopySubtext(attributedText.intToChunkPosition(this.textToCopyBegin), attributedText.intToChunkPosition(this.textToCopyEnd), this.deleteWithCopy);
            ClipboardHelper.getInstance().setClipboardContents(AttributedText.toText(this.textToClear));
            AttributedText.setClipBoard(AttributedText.getCopy(this.textToClear));
        }
        if (this.deleteWithCopy) {
            this.controller.setMarkingActive(false);
            this.controller.setMarkStart(0);
            this.controller.setMarkEnd(0);
        }
        this.controller.setCursor(this.cursorAfter);
        return true;
    }

    @Override
    public final boolean undoIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        if (this.textToClear != null && this.deleteWithCopy) {
            attributedText.insertAt(this.textToClear, attributedText.intToChunkPosition(this.textToCopyBegin));
        }
        if (this.textToCopyBegin != this.textToCopyEnd) {
            this.controller.setMarkingActive(true);
            this.controller.setMarkStart(this.textToCopyBegin);
            this.controller.setMarkEnd(this.textToCopyEnd);
        }
        this.controller.setCursor(this.cursorBefore);
        return false;
    }
}

